/*
 * Decompiled with CFR 0.152.
 */
package io.socket.engineio.server.transport;

import io.socket.engineio.parser.Packet;
import io.socket.engineio.parser.ServerParser;
import io.socket.engineio.server.Transport;
import io.socket.parseqs.ParseQS;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public final class Polling
extends Transport
implements AsyncListener {
    public static final String NAME = "polling";
    private static final List<Packet<?>> PACKET_CLOSE = Collections.unmodifiableList(new ArrayList<Packet<?>>(){
        {
            this.add(new Packet("close"));
        }
    });
    private static final List<Packet<?>> PACKET_NOOP = Collections.unmodifiableList(new ArrayList<Packet<?>>(){
        {
            this.add(new Packet("noop"));
        }
    });
    private HttpServletRequest mPollRequest;
    private HttpServletResponse mPollResponse;
    private boolean mWritable = false;
    private boolean mShouldClose = false;

    @Override
    public synchronized void onRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        switch (request.getMethod().toLowerCase()) {
            case "get": {
                this.onPollRequest(request, response);
                break;
            }
            case "post": {
                this.onDataRequest(request, response);
                break;
            }
            default: {
                response.setStatus(500);
                response.getWriter().write("");
            }
        }
    }

    @Override
    public synchronized void send(List<Packet<?>> packets) {
        Map query;
        this.mWritable = false;
        if (this.mShouldClose) {
            packets.add(new Packet("close"));
        }
        boolean supportsBinary = !(query = (Map)this.mPollRequest.getAttribute("query")).containsKey("b64");
        boolean jsonp = query.containsKey("j");
        if (packets.size() == 0) {
            throw new IllegalArgumentException("No packets to send.");
        }
        ServerParser.encodePayload(packets.toArray(new Packet[0]), supportsBinary, data -> {
            byte[] contentBytes;
            String contentType;
            if (jsonp) {
                String jsonpIndex = ((String)query.get("j")).replaceAll("[^0-9]", "");
                String jsonContentString = data instanceof String ? JSONObject.quote((String)((String)data)) : JSONObject.valueToString((Object)new JSONArray(data));
                String jsContentString = jsonContentString.replace("\u2028", "\\u2028").replace("\u2029", "\\u2029");
                String contentString = "___eio[" + jsonpIndex + "](" + jsContentString + ")";
                contentType = "text/javascript; charset=UTF-8";
                contentBytes = contentString.getBytes(StandardCharsets.UTF_8);
            } else {
                contentType = data instanceof String ? "text/plain; charset=UTF-8" : "application/octet-stream";
                contentBytes = data instanceof String ? ((String)data).getBytes(StandardCharsets.UTF_8) : (byte[])data;
            }
            this.mPollResponse.setContentType(contentType);
            this.mPollResponse.setContentLength(contentBytes.length);
            try (ServletOutputStream outputStream = this.mPollResponse.getOutputStream();){
                outputStream.write(contentBytes);
            }
            catch (IOException ex) {
                this.onError("write failure", ex.getMessage());
            }
            if (this.mPollRequest.isAsyncStarted()) {
                this.mPollRequest.getAsyncContext().complete();
            }
            this.mPollRequest = null;
            this.mPollResponse = null;
        });
        if (this.mShouldClose) {
            this.onClose();
        }
    }

    @Override
    public boolean isWritable() {
        return this.mWritable;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected synchronized void doClose() {
        if (this.mWritable) {
            this.send(new ArrayList(PACKET_CLOSE));
            this.onClose();
        } else {
            this.mShouldClose = true;
        }
    }

    @Override
    protected void onData(Object data) {
        ServerParser.decodePayload(data, (packet, index, total) -> {
            if (packet.type.equals("close")) {
                this.onClose();
                return false;
            }
            this.onPacket(packet);
            return true;
        });
    }

    @Override
    protected void onClose() {
        if (this.mWritable) {
            this.send(new ArrayList(PACKET_NOOP));
        }
        super.onClose();
    }

    public void onStartAsync(AsyncEvent asyncEvent) {
    }

    public void onComplete(AsyncEvent asyncEvent) {
    }

    public void onTimeout(AsyncEvent asyncEvent) {
        this.send(new ArrayList(PACKET_NOOP));
    }

    public void onError(AsyncEvent asyncEvent) {
        this.onError("async failure", null);
    }

    private void onPollRequest(HttpServletRequest request, HttpServletResponse response) {
        if (this.mPollRequest != null) {
            this.onError("overlap from client", "");
            this.mPollResponse.setStatus(500);
            try (PrintWriter writer2 = this.mPollResponse.getWriter();){
                writer2.print("error");
                writer2.flush();
            }
            catch (IOException writer2) {
                // empty catch block
            }
            return;
        }
        this.mPollRequest = request;
        this.mPollResponse = response;
        boolean asyncEnabled = false;
        if (request.isAsyncSupported() || request.isAsyncStarted()) {
            AsyncContext asyncContext = request.startAsync();
            asyncContext.addListener((AsyncListener)this);
            asyncContext.setTimeout(180000L);
            asyncEnabled = true;
        }
        this.mWritable = true;
        this.emit("drain", new Object[0]);
        if (this.mWritable && (!asyncEnabled || this.mShouldClose)) {
            this.send(new ArrayList(PACKET_NOOP));
        }
    }

    private void onDataRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map query = (Map)request.getAttribute("query");
        boolean isBinary = request.getContentType().equals("application/octet-stream");
        boolean jsonp = query.containsKey("j");
        try (ServletInputStream inputStream = request.getInputStream();){
            byte[] mReadBuffer = new byte[request.getContentLength()];
            inputStream.read(mReadBuffer, 0, mReadBuffer.length);
            if (jsonp) {
                String packetPayloadRaw = (String)ParseQS.decode((String)new String(mReadBuffer, StandardCharsets.UTF_8)).get("d");
                String packetPayload = packetPayloadRaw.replace("\\n", "\n");
                this.onData(packetPayload);
            } else {
                Object object;
                if (isBinary) {
                    object = mReadBuffer;
                } else {
                    String string;
                    object = string;
                    string = new String(mReadBuffer, StandardCharsets.UTF_8);
                }
                this.onData(object);
            }
        }
        response.setContentType("text/html");
        response.getWriter().write("ok");
    }
}

