/*
 * Decompiled with CFR 0.152.
 */
package com.turo.pushy.apns.server;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

class ServerChannelClassUtil {
    private static final Map<String, String> SERVER_SOCKET_CHANNEL_CLASSES = new HashMap<String, String>();

    static {
        SERVER_SOCKET_CHANNEL_CLASSES.put("io.netty.channel.nio.NioEventLoopGroup", "io.netty.channel.socket.nio.NioServerSocketChannel");
        SERVER_SOCKET_CHANNEL_CLASSES.put("io.netty.channel.oio.OioEventLoopGroup", "io.netty.channel.socket.oio.OioServerSocketChannel");
        SERVER_SOCKET_CHANNEL_CLASSES.put("io.netty.channel.epoll.EpollEventLoopGroup", "io.netty.channel.epoll.EpollServerSocketChannel");
        SERVER_SOCKET_CHANNEL_CLASSES.put("io.netty.channel.kqueue.KQueueEventLoopGroup", "io.netty.channel.kqueue.KQueueServerSocketChannel");
    }

    ServerChannelClassUtil() {
    }

    static Class<? extends ServerChannel> getServerSocketChannelClass(EventLoopGroup eventLoopGroup) {
        Objects.requireNonNull(eventLoopGroup);
        String serverSocketChannelClassName = SERVER_SOCKET_CHANNEL_CLASSES.get(eventLoopGroup.getClass().getName());
        if (serverSocketChannelClassName == null) {
            throw new IllegalArgumentException("No server socket channel class found for event loop group type: " + eventLoopGroup.getClass().getName());
        }
        try {
            return Class.forName(serverSocketChannelClassName).asSubclass(ServerChannel.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

