/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.local;

import io.github.bucket4j.AbstractBucket;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketListener;
import io.github.bucket4j.BucketState;
import io.github.bucket4j.ConsumptionProbe;
import io.github.bucket4j.EstimationProbe;
import io.github.bucket4j.MathType;
import io.github.bucket4j.Nothing;
import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.TokensInheritanceStrategy;
import io.github.bucket4j.VerboseResult;
import io.github.bucket4j.local.LocalBucket;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SynchronizedBucket
extends AbstractBucket
implements LocalBucket {
    private BucketConfiguration configuration;
    private Bandwidth[] bandwidths;
    private final TimeMeter timeMeter;
    private BucketState state;
    private final Lock lock;

    public SynchronizedBucket(BucketConfiguration configuration, MathType mathType, TimeMeter timeMeter) {
        this(configuration, mathType, timeMeter, new ReentrantLock());
    }

    SynchronizedBucket(BucketConfiguration configuration, MathType mathType, TimeMeter timeMeter, Lock lock) {
        this(BucketListener.NOPE, configuration, timeMeter, lock, BucketState.createInitialState(configuration, mathType, timeMeter.currentTimeNanos()));
    }

    private SynchronizedBucket(BucketListener listener, BucketConfiguration configuration, TimeMeter timeMeter, Lock lock, BucketState initialState) {
        super(listener);
        this.configuration = configuration;
        this.bandwidths = configuration.getBandwidths();
        this.timeMeter = timeMeter;
        this.state = initialState;
        this.lock = lock;
    }

    @Override
    public Bucket toListenable(BucketListener listener) {
        return new SynchronizedBucket(listener, this.configuration, this.timeMeter, this.lock, this.state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long consumeAsMuchAsPossibleImpl(long limit) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            long availableToConsume = this.state.getAvailableTokens(this.bandwidths);
            long toConsume = Math.min(limit, availableToConsume);
            if (toConsume == 0L) {
                long l = 0L;
                return l;
            }
            this.state.consume(this.bandwidths, toConsume);
            long l = toConsume;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean tryConsumeImpl(long tokensToConsume) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            long availableToConsume = this.state.getAvailableTokens(this.bandwidths);
            if (tokensToConsume > availableToConsume) {
                boolean bl = false;
                return bl;
            }
            this.state.consume(this.bandwidths, tokensToConsume);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ConsumptionProbe tryConsumeAndReturnRemainingTokensImpl(long tokensToConsume) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            long availableToConsume = this.state.getAvailableTokens(this.bandwidths);
            if (tokensToConsume > availableToConsume) {
                long nanosToWaitForRefill = this.state.calculateDelayNanosAfterWillBePossibleToConsume(this.bandwidths, tokensToConsume, currentTimeNanos);
                long nanosToWaitForReset = this.state.calculateFullRefillingTime(this.bandwidths, currentTimeNanos);
                ConsumptionProbe consumptionProbe = ConsumptionProbe.rejected(availableToConsume, nanosToWaitForRefill, nanosToWaitForReset);
                return consumptionProbe;
            }
            this.state.consume(this.bandwidths, tokensToConsume);
            long remainingTokens = availableToConsume - tokensToConsume;
            long nanosToWaitForReset = this.state.calculateFullRefillingTime(this.bandwidths, currentTimeNanos);
            ConsumptionProbe consumptionProbe = ConsumptionProbe.consumed(remainingTokens, nanosToWaitForReset);
            return consumptionProbe;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected EstimationProbe estimateAbilityToConsumeImpl(long tokensToEstimate) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            long availableToConsume = this.state.getAvailableTokens(this.bandwidths);
            if (tokensToEstimate > availableToConsume) {
                long nanosToWaitForRefill = this.state.calculateDelayNanosAfterWillBePossibleToConsume(this.bandwidths, tokensToEstimate, currentTimeNanos);
                EstimationProbe estimationProbe = EstimationProbe.canNotBeConsumed(availableToConsume, nanosToWaitForRefill);
                return estimationProbe;
            }
            EstimationProbe estimationProbe = EstimationProbe.canBeConsumed(availableToConsume);
            return estimationProbe;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long reserveAndCalculateTimeToSleepImpl(long tokensToConsume, long waitIfBusyNanosLimit) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            long nanosToCloseDeficit = this.state.calculateDelayNanosAfterWillBePossibleToConsume(this.bandwidths, tokensToConsume, currentTimeNanos);
            if (nanosToCloseDeficit == Long.MAX_VALUE || nanosToCloseDeficit > waitIfBusyNanosLimit) {
                long l = Long.MAX_VALUE;
                return l;
            }
            this.state.consume(this.bandwidths, tokensToConsume);
            long l = nanosToCloseDeficit;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long consumeIgnoringRateLimitsImpl(long tokensToConsume) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            long nanosToCloseDeficit = this.state.calculateDelayNanosAfterWillBePossibleToConsume(this.bandwidths, tokensToConsume, currentTimeNanos);
            if (nanosToCloseDeficit == INFINITY_DURATION) {
                long l = nanosToCloseDeficit;
                return l;
            }
            this.state.consume(this.bandwidths, tokensToConsume);
            long l = nanosToCloseDeficit;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected VerboseResult<Long> consumeAsMuchAsPossibleVerboseImpl(long limit) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            long availableToConsume = this.state.getAvailableTokens(this.bandwidths);
            long toConsume = Math.min(limit, availableToConsume);
            if (toConsume == 0L) {
                VerboseResult<Long> verboseResult = new VerboseResult<Long>(currentTimeNanos, 0L, this.configuration, this.state.copy());
                return verboseResult;
            }
            this.state.consume(this.bandwidths, toConsume);
            VerboseResult<Long> verboseResult = new VerboseResult<Long>(currentTimeNanos, toConsume, this.configuration, this.state.copy());
            return verboseResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected VerboseResult<Boolean> tryConsumeVerboseImpl(long tokensToConsume) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            long availableToConsume = this.state.getAvailableTokens(this.bandwidths);
            if (tokensToConsume > availableToConsume) {
                VerboseResult<Boolean> verboseResult = new VerboseResult<Boolean>(currentTimeNanos, false, this.configuration, this.state.copy());
                return verboseResult;
            }
            this.state.consume(this.bandwidths, tokensToConsume);
            VerboseResult<Boolean> verboseResult = new VerboseResult<Boolean>(currentTimeNanos, true, this.configuration, this.state.copy());
            return verboseResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected VerboseResult<ConsumptionProbe> tryConsumeAndReturnRemainingTokensVerboseImpl(long tokensToConsume) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            long availableToConsume = this.state.getAvailableTokens(this.bandwidths);
            if (tokensToConsume > availableToConsume) {
                long nanosToWaitForRefill = this.state.calculateDelayNanosAfterWillBePossibleToConsume(this.bandwidths, tokensToConsume, currentTimeNanos);
                long nanosToWaitForReset = this.state.calculateFullRefillingTime(this.bandwidths, currentTimeNanos);
                ConsumptionProbe probe = ConsumptionProbe.rejected(availableToConsume, nanosToWaitForRefill, nanosToWaitForReset);
                VerboseResult<ConsumptionProbe> verboseResult = new VerboseResult<ConsumptionProbe>(currentTimeNanos, probe, this.configuration, this.state.copy());
                return verboseResult;
            }
            this.state.consume(this.bandwidths, tokensToConsume);
            long nanosToWaitForReset = this.state.calculateFullRefillingTime(this.bandwidths, currentTimeNanos);
            ConsumptionProbe probe = ConsumptionProbe.consumed(availableToConsume - tokensToConsume, nanosToWaitForReset);
            VerboseResult<ConsumptionProbe> verboseResult = new VerboseResult<ConsumptionProbe>(currentTimeNanos, probe, this.configuration, this.state.copy());
            return verboseResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected VerboseResult<EstimationProbe> estimateAbilityToConsumeVerboseImpl(long tokensToEstimate) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            long availableToConsume = this.state.getAvailableTokens(this.bandwidths);
            if (tokensToEstimate > availableToConsume) {
                long nanosToWaitForRefill = this.state.calculateDelayNanosAfterWillBePossibleToConsume(this.bandwidths, tokensToEstimate, currentTimeNanos);
                EstimationProbe estimationProbe = EstimationProbe.canNotBeConsumed(availableToConsume, nanosToWaitForRefill);
                VerboseResult<EstimationProbe> verboseResult = new VerboseResult<EstimationProbe>(currentTimeNanos, estimationProbe, this.configuration, this.state.copy());
                return verboseResult;
            }
            EstimationProbe estimationProbe = EstimationProbe.canBeConsumed(availableToConsume);
            VerboseResult<EstimationProbe> verboseResult = new VerboseResult<EstimationProbe>(currentTimeNanos, estimationProbe, this.configuration, this.state.copy());
            return verboseResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected VerboseResult<Long> getAvailableTokensVerboseImpl() {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            long availableTokens = this.state.getAvailableTokens(this.bandwidths);
            VerboseResult<Long> verboseResult = new VerboseResult<Long>(currentTimeNanos, availableTokens, this.configuration, this.state.copy());
            return verboseResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected VerboseResult<Nothing> addTokensVerboseImpl(long tokensToAdd) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            this.state.addTokens(this.bandwidths, tokensToAdd);
            VerboseResult<Nothing> verboseResult = new VerboseResult<Nothing>(currentTimeNanos, Nothing.INSTANCE, this.configuration, this.state.copy());
            return verboseResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected VerboseResult<Nothing> forceAddTokensVerboseImpl(long tokensToAdd) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            this.state.forceAddTokens(this.bandwidths, tokensToAdd);
            VerboseResult<Nothing> verboseResult = new VerboseResult<Nothing>(currentTimeNanos, Nothing.INSTANCE, this.configuration, this.state.copy());
            return verboseResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected VerboseResult<Nothing> replaceConfigurationVerboseImpl(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            this.state = this.state.replaceConfiguration(this.configuration, newConfiguration, tokensInheritanceStrategy, currentTimeNanos);
            this.bandwidths = newConfiguration.getBandwidths();
            this.configuration = newConfiguration;
            VerboseResult<Object> verboseResult = new VerboseResult<Object>(currentTimeNanos, null, this.configuration, this.state.copy());
            return verboseResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected VerboseResult<Long> consumeIgnoringRateLimitsVerboseImpl(long tokensToConsume) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            long nanosToCloseDeficit = this.state.calculateDelayNanosAfterWillBePossibleToConsume(this.bandwidths, tokensToConsume, currentTimeNanos);
            if (nanosToCloseDeficit == INFINITY_DURATION) {
                VerboseResult<Long> verboseResult = new VerboseResult<Long>(currentTimeNanos, nanosToCloseDeficit, this.configuration, this.state.copy());
                return verboseResult;
            }
            this.state.consume(this.bandwidths, tokensToConsume);
            VerboseResult<Long> verboseResult = new VerboseResult<Long>(currentTimeNanos, nanosToCloseDeficit, this.configuration, this.state.copy());
            return verboseResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addTokensImpl(long tokensToAdd) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            this.state.addTokens(this.bandwidths, tokensToAdd);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void forceAddTokensImpl(long tokensToAdd) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            this.state.forceAddTokens(this.bandwidths, tokensToAdd);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAvailableTokens() {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            long l = this.state.getAvailableTokens(this.bandwidths);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void replaceConfigurationImpl(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            this.state = this.state.replaceConfiguration(this.configuration, newConfiguration, tokensInheritanceStrategy, currentTimeNanos);
            this.configuration = newConfiguration;
            this.bandwidths = newConfiguration.getBandwidths();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public BucketConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public TimeMeter getTimeMeter() {
        return this.timeMeter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        SynchronizedBucket synchronizedBucket = this;
        synchronized (synchronizedBucket) {
            return "SynchronizedBucket{state=" + this.state + ", configuration=" + this.getConfiguration() + '}';
        }
    }
}

