/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketState;
import io.github.bucket4j.TokensInheritanceStrategy;
import io.github.bucket4j.distributed.remote.RemoteStat;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;

public class RemoteBucketState
implements ComparableByContent<RemoteBucketState> {
    private BucketConfiguration configuration;
    private BucketState state;
    private RemoteStat stat;
    public static final SerializationHandle<RemoteBucketState> SERIALIZATION_HANDLE = new SerializationHandle<RemoteBucketState>(){

        @Override
        public <S> RemoteBucketState deserialize(DeserializationAdapter<S> adapter, S input, Version backwardCompatibilityVersion) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            BucketConfiguration bucketConfiguration = BucketConfiguration.SERIALIZATION_HANDLE.deserialize(adapter, input, backwardCompatibilityVersion);
            BucketState bucketState = BucketState.deserialize(adapter, input, backwardCompatibilityVersion);
            RemoteStat stat = RemoteStat.SERIALIZATION_HANDLE.deserialize(adapter, input, backwardCompatibilityVersion);
            return new RemoteBucketState(bucketConfiguration, bucketState, stat);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, RemoteBucketState gridState, Version backwardCompatibilityVersion) throws IOException {
            adapter.writeInt(output, Versions.v_7_0_0.getNumber());
            BucketConfiguration.SERIALIZATION_HANDLE.serialize(adapter, output, gridState.configuration, backwardCompatibilityVersion);
            BucketState.serialize(adapter, output, gridState.state, backwardCompatibilityVersion);
            RemoteStat.SERIALIZATION_HANDLE.serialize(adapter, output, gridState.stat, backwardCompatibilityVersion);
        }

        @Override
        public int getTypeId() {
            return 5;
        }

        @Override
        public Class<RemoteBucketState> getSerializedType() {
            return RemoteBucketState.class;
        }
    };

    public RemoteBucketState(BucketConfiguration configuration, BucketState state, RemoteStat stat) {
        this.configuration = configuration;
        this.state = state;
        this.stat = stat;
    }

    public void refillAllBandwidth(long currentTimeNanos) {
        this.state.refillAllBandwidth(this.configuration.getBandwidths(), currentTimeNanos);
    }

    public long getAvailableTokens() {
        return this.state.getAvailableTokens(this.configuration.getBandwidths());
    }

    public void consume(long tokensToConsume) {
        this.state.consume(this.configuration.getBandwidths(), tokensToConsume);
        this.stat.addConsumedTokens(tokensToConsume);
    }

    public long calculateFullRefillingTime(long currentTimeNanos) {
        return this.state.calculateFullRefillingTime(this.configuration.getBandwidths(), currentTimeNanos);
    }

    public long calculateDelayNanosAfterWillBePossibleToConsume(long tokensToConsume, long currentTimeNanos) {
        return this.state.calculateDelayNanosAfterWillBePossibleToConsume(this.configuration.getBandwidths(), tokensToConsume, currentTimeNanos);
    }

    public void addTokens(long tokensToAdd) {
        this.state.addTokens(this.configuration.getBandwidths(), tokensToAdd);
    }

    public void forceAddTokens(long tokensToAdd) {
        this.state.forceAddTokens(this.configuration.getBandwidths(), tokensToAdd);
    }

    public BucketState copyBucketState() {
        return this.state.copy();
    }

    public void replaceConfiguration(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy, long currentTimeNanos) {
        this.state = this.state.replaceConfiguration(this.configuration, newConfiguration, tokensInheritanceStrategy, currentTimeNanos);
        this.configuration = newConfiguration;
    }

    public BucketConfiguration getConfiguration() {
        return this.configuration;
    }

    public RemoteStat getRemoteStat() {
        return this.stat;
    }

    public BucketState getState() {
        return this.state;
    }

    @Override
    public boolean equalsByContent(RemoteBucketState other) {
        return ComparableByContent.equals(this.state, other.state) && ComparableByContent.equals(this.configuration, other.configuration) && ComparableByContent.equals(this.stat, other.stat);
    }

    public RemoteBucketState copy() {
        return new RemoteBucketState(this.configuration, this.state.copy(), this.stat.copy());
    }

    public String toString() {
        return "RemoteBucketState{configuration=" + this.configuration + ", state=" + this.state + ", stat=" + this.stat + '}';
    }
}

