/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef.mime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import net.freeutils.tnef.Attr;
import net.freeutils.tnef.MAPIProp;
import net.freeutils.tnef.MAPIPropName;
import net.freeutils.tnef.MAPIValue;
import net.freeutils.tnef.Message;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEFUtils;
import net.freeutils.tnef.mime.Converter;
import net.freeutils.tnef.mime.TNEFMime;
import net.freeutils.tnef.mime.TNEFMimeMessage;

public class ContactConverter
extends Converter {
    static ContactField[] contactFields = new ContactField[]{new ContactField("BEGIN", "VCARD"), new ContactField("VERSION", "3.0"), new ContactField("FN", 1, "%s %s %s %s", 14854, 14916, 14865, 14853), new ContactField("N", 1, "%s;%s;%s;%s;%s", 14865, 14854, 14916, 14917, 14853), new ContactField("NICKNAME", 14927), new ContactField("BDAY", 0, "yyyy-MM-dd'T'HH:mm:ss'Z'", (Object)14914), new ContactField("ADR;TYPE=WORK", 0, "%s;%s;%s;%s;%s;%s;%s", null, 14873, 14889, 14887, 14888, 14890, 14886), new ContactField("LABEL;TYPE=WORK", 0, "%s\r\n%s\r\n%s, %s %s\r\n%s", 14873, 14889, 14887, 14888, 14890, 14886), new ContactField("ADR;TYPE=HOME", 0, "%s;%s;%s;%s;%s;%s;%s", null, null, 14941, 14937, 14940, 14939, 14938), new ContactField("LABEL;TYPE=HOME", 0, "%s\r\n%s, %s %s\r\n%s", 14941, 14937, 14940, 14939, 14938), new ContactField("ADR;TYPE=POSTAL", 0, "%s;%s;%s;%s;%s;%s;%s", null, null, 14947, 14943, 14946, 14945, 14944), new ContactField("LABEL;TYPE=POSTAL", 0, "%s\r\n%s, %s %s\r\n%s", 14947, 14943, 14946, 14945, 14944), new ContactField("TEL;TYPE=HOME,VOICE", 14857), new ContactField("TEL;TYPE=HOME", 14895), new ContactField("TEL;TYPE=HOME,FAX", 14885), new ContactField("TEL;TYPE=WORK,VOICE", 14856), new ContactField("TEL;TYPE=WORK,VOICE", 14875), new ContactField("TEL;TYPE=WORK,FAX", 14884), new ContactField("TEL;TYPE=CELL,VOICE", 14876), new ContactField("TEL;TYPE=CAR,VOICE", 14878), new ContactField("TEL;TYPE=PREF,VOICE", 14850), new ContactField("TEL;TYPE=VOICE", 14879), new ContactField("TEL;TYPE=PAGER,VOICE", 14881), new ContactField("TEL;TYPE=ISDN", 14893), new ContactField("TEL;TYPE=PREF", 14874), new ContactField("EMAIL;TYPE=PREF,INTERNET", new MAPIPropName(MAPIProp.PSETID_Address, 32899L)), new ContactField("EMAIL;TYPE=TLX", 14892), new ContactField("TITLE", 14871), new ContactField("ROLE", 14918), new ContactField("ORG", 0, "%s;%s", 14870, 14872), new ContactField("NOTE", 2, null, (Object)32780), new ContactField("URL;TYPE=WORK", 14929), new ContactField("KEY;TYPE=X509", 12, null, (Object)14960), new ContactField("END", "VCARD")};

    public boolean canConvert(Message message) {
        return this.isMessageClass(message, "IPM.Contact");
    }

    public TNEFMimeMessage convert(Message message, TNEFMimeMessage mime) throws IOException, MessagingException {
        StringBuilder vcard = new StringBuilder();
        for (ContactField contactField : contactFields) {
            String v = contactField.getValue(message);
            if (v == null) continue;
            vcard.append(v);
        }
        String name = null;
        Attr attr = message.getAttribute(32772);
        if (attr != null) {
            name = (String)attr.getValue();
        }
        if (name == null || name.length() == 0) {
            name = "contact";
        }
        name = '\"' + MimeUtility.encodeWord((String)(name + ".vcf"), (String)"UTF-8", null) + '\"';
        MimeMultipart mp = new MimeMultipart();
        MimeBodyPart part = TNEFMime.addTextPart((Multipart)mp, vcard.toString(), "text/x-vcard; name=" + name);
        part.setHeader("Content-Disposition", "attachment; filename=" + name);
        mime.setContent((Multipart)mp);
        return mime;
    }

    static class ContactField {
        public static final int NONE = 0;
        public static final int MUST = 1;
        public static final int ATTR = 2;
        public static final int BINARY = 4;
        public static final int CERT = 8;
        String type;
        int flags;
        String format;
        Object src;

        public ContactField(String type, int flags, String format, Object src) {
            this.type = type;
            this.src = src;
            this.flags = flags;
            this.format = format;
            if (this.isFlag(4)) {
                this.type = this.type + ";ENCODING=b";
            }
        }

        public ContactField(String type, int flags, String format, Integer ... src) {
            this(type, flags, format, src.length == 1 ? src[0] : src);
        }

        public ContactField(String type, Object src) {
            this(type, 0, null, src);
        }

        public String getValue(Message message) throws IOException {
            String v = null;
            if (this.src instanceof Integer) {
                int id = (Integer)this.src;
                if (this.isFlag(2)) {
                    Attr attr = message.getAttribute(id);
                    if (attr != null) {
                        v = this.toVCardField(this.toString(attr.getValue()), true);
                    }
                } else {
                    v = this.toVCardFields(message.getMAPIProps().getProp(id));
                }
            } else if (this.src instanceof MAPIPropName) {
                MAPIPropName propname = (MAPIPropName)this.src;
                v = this.toVCardFields(message.getMAPIProps().getProp(propname));
            } else if (this.src instanceof Integer[]) {
                Integer[] ids = (Integer[])this.src;
                int len = ids.length;
                Object[] vals = new String[len];
                boolean hasValue = false;
                for (int i = 0; i < len; ++i) {
                    if (ids[i] != null) {
                        vals[i] = ContactField.escape((String)message.getMAPIProps().getPropValue(ids[i]));
                    }
                    if (vals[i] == null) {
                        vals[i] = "";
                        continue;
                    }
                    hasValue = true;
                }
                if (hasValue) {
                    v = this.toVCardField(String.format(this.format, vals), false);
                }
            } else if (this.src instanceof String) {
                v = this.toVCardField((String)this.src, true);
            } else {
                throw new IllegalArgumentException("Invalid source: " + this.src);
            }
            return v;
        }

        private String toVCardFields(MAPIProp prop) throws IOException {
            String v = null;
            if (prop != null) {
                v = "";
                for (MAPIValue val : prop.getValues()) {
                    String vstr;
                    if (val == null || (vstr = this.toVCardField(this.toString(val.getValue()), true)) == null) continue;
                    v = v + vstr;
                }
            }
            return v;
        }

        String toVCardField(String v, boolean escape) {
            if (escape) {
                v = ContactField.escape(v);
            }
            if (v != null && v.trim().length() == 0) {
                v = null;
            }
            if (this.isFlag(1) && v == null) {
                v = "";
            }
            if (v != null) {
                v = TNEFUtils.replace(v, "\r\n", "\\n");
                v = TNEFUtils.replace(v, "\n", "\\n");
                v = this.fold(this.type + ":" + v) + "\r\n";
            }
            return v;
        }

        boolean isFlag(int flag) {
            return (this.flags & flag) != 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        String toString(Object val) throws IOException {
            if (val == null) {
                return null;
            }
            if (val instanceof Date) {
                return TNEFUtils.formatDate(((Date)val).getTime(), this.format);
            }
            if (!(val instanceof RawInputStream)) return val.toString();
            RawInputStream ris = (RawInputStream)val;
            String v = null;
            try {
                if (this.isFlag(8)) {
                    RawInputStream cert = ContactField.getTLVProp(ris, 3);
                    if (cert == null) return v;
                    try {
                        if (cert.available() <= 32) return v;
                        v = ContactField.toBase64(cert);
                        return v;
                    }
                    finally {
                        cert.close();
                    }
                }
                v = ContactField.toBase64(ris);
                return v;
            }
            finally {
                ris.close();
            }
        }

        String fold(String v) {
            int vlen = v.length();
            if (vlen > 75) {
                StringBuilder folded = new StringBuilder((int)((double)vlen * 1.04));
                int breakpos = -1;
                int count = 0;
                int i = 0;
                while (i < vlen) {
                    char ch = v.charAt(i);
                    if (Character.isWhitespace(ch) || ch == '\\') {
                        breakpos = i;
                    }
                    if (count == 74) {
                        if (breakpos == -1) {
                            breakpos = i;
                        }
                        folded.append(v.substring(i - count, breakpos)).append("\r\n ");
                        count = i - breakpos;
                        breakpos = -1;
                    }
                    ++i;
                    ++count;
                }
                if (count > 0) {
                    folded.append(v.substring(vlen - count));
                }
                v = folded.toString();
            }
            return v;
        }

        static String escape(String v) {
            if (v == null) {
                return null;
            }
            v = TNEFUtils.replace(v, "\r\n", "\\n");
            v = TNEFUtils.replace(v, "\n", "\\n");
            v = TNEFUtils.replace(v, ",", "\\,");
            v = TNEFUtils.replace(v, ";", "\\;");
            return v;
        }

        static String toBase64(InputStream in) throws IOException {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                OutputStream out = MimeUtility.encode((OutputStream)bout, (String)"base64");
                TNEFUtils.transfer(in, out, -1L, false, true);
                String s = bout.toString("US-ASCII");
                return TNEFUtils.replace(s, "\r\n", "");
            }
            catch (MessagingException me) {
                throw new IOException(me.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static RawInputStream getTLVProp(RawInputStream in, int tag) throws IOException {
            in = new RawInputStream(in);
            try {
                while (in.available() >= 4) {
                    int tg = in.readU16();
                    int len = in.readU16() - 4;
                    if (tg == tag) {
                        RawInputStream rawInputStream = (RawInputStream)in.newStream(0L, len);
                        return rawInputStream;
                    }
                    in.skip(len);
                }
                RawInputStream rawInputStream = null;
                return rawInputStream;
            }
            finally {
                in.close();
            }
        }
    }
}

