/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import net.freeutils.tnef.Attachment;
import net.freeutils.tnef.Message;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEFInputStream;
import net.freeutils.tnef.TNEFUtils;

public class TNEF {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int extractContent(TNEFInputStream in, String outputdir) throws IOException {
        Message message = new Message(in);
        try {
            int n = TNEF.extractContent(message, outputdir);
            return n;
        }
        finally {
            message.close();
        }
    }

    public static int extractContent(Message message, String outputdir) throws IOException {
        System.out.println(message);
        int count = TNEF.extractAttachments(message, outputdir);
        System.out.println("\nWrote " + count + " attachments.");
        return count;
    }

    public static int extractAttachments(Message message, String outputdir) throws IOException {
        if (!outputdir.endsWith(File.separator)) {
            outputdir = outputdir + File.separator;
        }
        int count = 0;
        for (Attachment attachment : message.getAttachments()) {
            if (attachment.getNestedMessage() != null) {
                count += TNEF.extractAttachments(attachment.getNestedMessage(), outputdir);
                continue;
            }
            ++count;
            String filename = attachment.getFilename();
            if (filename != null) {
                filename = filename.replaceAll("(.*[/\\\\])*", "");
            }
            if (filename == null || filename.replace(".", "").length() == 0) {
                filename = "attachment" + count;
            }
            filename = outputdir + filename;
            System.out.println("\n>>> Writing attachment #" + count + " to " + filename);
            attachment.writeTo(filename);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        String tneffile;
        block11: {
            if (args.length < 1 || args.length > 2) {
                String usage = "Usage: java net.freeutils.tnef.TNEF <tneffile> [outputdir]\n\nExample: java net.freeutils.tnef.TNEF c:\\temp\\winmail.dat c:\\temp\\attachments\n";
                System.out.println(usage);
                System.exit(1);
            }
            tneffile = args[0];
            String outputdir = args.length < 2 ? "." : args[1];
            System.out.println("Processing TNEF file " + tneffile + "\n");
            RawInputStream ris = null;
            TNEFInputStream in = null;
            ris = new RawInputStream(tneffile);
            in = new TNEFInputStream(ris);
            TNEF.extractContent(in, outputdir);
            try {
                TNEFUtils.closeAll((Closeable[])new Closeable[]{in, ris});
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            break block11;
            catch (Throwable t) {
                try {
                    t.printStackTrace();
                    System.out.println("Operation aborted.");
                    System.exit(-1);
                }
                catch (Throwable throwable) {
                    try {
                        TNEFUtils.closeAll((Closeable[])new Closeable[]{in, ris});
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    TNEFUtils.closeAll((Closeable[])new Closeable[]{in, ris});
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        System.out.println("\nFinished processing TNEF file " + tneffile);
    }
}

