/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef;

import java.io.Closeable;
import java.io.IOException;
import java.util.Date;
import net.freeutils.tnef.GUID;
import net.freeutils.tnef.MAPIProp;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEFInputStream;
import net.freeutils.tnef.TNEFUtils;

public class MAPIValue
implements Closeable {
    int type;
    RawInputStream rawData;

    public MAPIValue(int type, RawInputStream data, int length) throws IOException {
        if ((type & 0x1000) != 0) {
            throw new IllegalArgumentException("multivalue is not allowed in single MAPIValue");
        }
        this.type = type;
        this.rawData = new RawInputStream(data, 0L, (long)length);
        data.skip(length);
    }

    public int getType() {
        return this.type;
    }

    public int getLength() {
        return (int)this.rawData.getLength();
    }

    public byte[] getData() {
        try {
            return this.rawData.toByteArray();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public RawInputStream getRawData() throws IOException {
        return new RawInputStream(this.rawData);
    }

    public void close() throws IOException {
        this.rawData.close();
    }

    public String toString() {
        String string;
        Object o = this.getValue();
        try {
            if (o instanceof byte[]) {
                o = TNEFUtils.toHexString((byte[])o, 512);
            }
            if (o instanceof Date) {
                o = TNEFUtils.formatDate(((Date)o).getTime(), "yyyy-MM-dd'T'HH:mm:ss");
            }
            string = String.valueOf(o);
        }
        catch (Throwable throwable) {
            try {
                if (o instanceof Closeable) {
                    ((Closeable)o).close();
                }
                throw throwable;
            }
            catch (IOException ioe) {
                return "ERROR: " + ioe;
            }
        }
        if (o instanceof Closeable) {
            ((Closeable)o).close();
        }
        return string;
    }

    public Object getValue() throws IOException {
        boolean closeStream = true;
        RawInputStream ris = new RawInputStream(this.rawData);
        try {
            switch (this.type) {
                case 1: {
                    Object var3_3 = null;
                    return var3_3;
                }
                case 11: {
                    Boolean bl = ris.readU16() != 0;
                    return bl;
                }
                case 2: {
                    Short s = (short)ris.readU16();
                    return s;
                }
                case 3: {
                    Integer n = (int)ris.readU32();
                    return n;
                }
                case 4: {
                    Float f = Float.valueOf(Float.intBitsToFloat((int)ris.readU32()));
                    return f;
                }
                case 10: {
                    Integer n = (int)ris.readU32();
                    return n;
                }
                case 7: {
                    double d = Double.longBitsToDouble(ris.readU64());
                    long millis = (long)(d * 1000.0 * 60.0 * 60.0 * 24.0);
                    Date date = new Date(millis -= 2209161600000L);
                    return date;
                }
                case 64: {
                    long time = ris.readU64() / 10000L;
                    Date date = new Date(time -= 11644473600000L);
                    return date;
                }
                case 5: {
                    Double d = Double.longBitsToDouble(ris.readU64());
                    return d;
                }
                case 6: 
                case 20: {
                    Long l = ris.readU64();
                    return l;
                }
                case 72: {
                    byte[] byArray = ris.toByteArray();
                    return byArray;
                }
                case 30: {
                    String string = ris.readString((int)ris.getLength());
                    return string;
                }
                case 31: {
                    String string = ris.readStringUnicode((int)ris.getLength());
                    return string;
                }
                case 0: 
                case 258: {
                    closeStream = false;
                    RawInputStream rawInputStream = ris;
                    return rawInputStream;
                }
                case 13: {
                    closeStream = false;
                    GUID iid = new GUID(ris.readBytes(16));
                    Closeable closeable = iid.equals(MAPIProp.IID_IMESSAGE) ? new TNEFInputStream(ris) : ris;
                    return closeable;
                }
            }
            throw new IOException("Unknown MAPI type: " + this.type);
        }
        finally {
            if (closeStream) {
                ris.close();
            }
        }
    }
}

