/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef;

import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.freeutils.tnef.Attr;
import net.freeutils.tnef.MAPIProp;
import net.freeutils.tnef.MAPIProps;
import net.freeutils.tnef.MAPIValue;
import net.freeutils.tnef.Message;
import net.freeutils.tnef.RawInputStream;
import net.freeutils.tnef.TNEFInputStream;
import net.freeutils.tnef.TNEFUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attachment
implements Closeable {
    List<Attr> attributes = new ArrayList<Attr>();
    String filename;
    RawInputStream rawData;
    MAPIProps props;
    Message nestedMessage;

    public List<Attr> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<Attr> attributes) {
        this.attributes = attributes;
    }

    public Attr getAttribute(int id) {
        return Attr.findAttr(this.attributes, id);
    }

    public String getFilename() {
        if (this.filename == null) {
            try {
                Attr attr;
                if (this.props != null) {
                    this.filename = (String)this.props.getPropValue(14087);
                    if (this.filename == null) {
                        this.filename = (String)this.props.getPropValue(14084);
                    }
                }
                if (this.filename == null && (attr = this.getAttribute(36865)) != null) {
                    this.filename = (String)attr.getValue();
                }
                if (this.filename == null && (attr = this.getAttribute(32784)) != null) {
                    this.filename = (String)attr.getValue();
                }
            }
            catch (IOException ioe) {
                this.filename = null;
            }
        }
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void addAttribute(Attr attr) {
        this.attributes.add(attr);
    }

    public RawInputStream getRawData() {
        return this.rawData;
    }

    public void setRawData(RawInputStream rawData) {
        if (this.rawData != null) {
            try {
                this.rawData.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.rawData = rawData;
    }

    public Message getNestedMessage() {
        return this.nestedMessage;
    }

    public void setNestedMessage(Message nestedMessage) {
        this.nestedMessage = nestedMessage;
    }

    public MAPIProps getMAPIProps() {
        return this.props;
    }

    @Override
    public void close() throws IOException {
        TNEFUtils.closeAll(this.attributes);
        TNEFUtils.closeAll((Closeable[])new Closeable[]{this.rawData, this.props, this.nestedMessage});
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Attachment:");
        for (Attr attribute : this.attributes) {
            s.append("\n  ").append(attribute);
        }
        if (this.rawData != null) {
            s.append("\n  data=").append(this.rawData);
        }
        if (this.props != null) {
            s.append("\n  props=");
            for (MAPIProp prop : this.props.getProps()) {
                s.append("\n    ").append(prop);
            }
        }
        if (this.nestedMessage != null) {
            s.append("\n  Nested Message:").append(this.nestedMessage);
        }
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMAPIProps(MAPIProps props) throws IOException {
        MAPIValue value;
        MAPIProp prop;
        this.props = props;
        if (props != null && (prop = props.getProp(14081)) != null && prop.getLength() > 0 && (value = prop.getValues()[0]) != null) {
            RawInputStream data = value.getRawData();
            if (prop.getType() == 13) {
                data.readBytes(16);
            }
            this.setRawData(data);
            Object o = value.getValue();
            try {
                if (o instanceof TNEFInputStream) {
                    this.setNestedMessage(new Message((TNEFInputStream)o));
                }
            }
            finally {
                if (o instanceof Closeable) {
                    ((Closeable)o).close();
                }
            }
        }
    }

    public void writeTo(String filename) throws IOException {
        FileOutputStream fos = new FileOutputStream(filename);
        try {
            this.writeTo(fos);
        }
        finally {
            fos.close();
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        if (this.rawData != null) {
            TNEFUtils.transfer(new RawInputStream(this.rawData), out, -1L, true, false);
        }
    }
}

