/*
 * Decompiled with CFR 0.152.
 */
package org.fishwife.jrugged;

import org.fishwife.jrugged.Initializable;

public class Initializer
implements Runnable {
    private int maxRetries = Integer.MAX_VALUE;
    private int numAttempts = 0;
    private long retryMillis = 60000L;
    private Initializable client;
    private boolean initialized = false;
    private Thread thread;
    private boolean cancelled = false;

    public Initializer(Initializable client) {
        this.client = client;
    }

    public void initialize() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void destroy() {
        this.cancelled = true;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public void run() {
        while (!this.initialized && this.numAttempts < this.maxRetries && !this.cancelled) {
            try {
                ++this.numAttempts;
                this.client.tryInit();
                this.initialized = true;
                this.client.afterInit();
            }
            catch (Exception e) {
                try {
                    Thread.sleep(this.retryMillis);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (!this.initialized && this.numAttempts >= this.maxRetries && !this.cancelled) {
            this.client.configuredRetriesMetOrExceededWithoutSuccess();
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public int getNumAttempts() {
        return this.numAttempts;
    }

    public void setMaxRetries(int n) {
        this.maxRetries = n;
    }

    public void setRetryMillis(long m) {
        this.retryMillis = m;
    }
}

