/*
 * Decompiled with CFR 0.152.
 */
package org.fishwife.jrugged;

import java.util.concurrent.Callable;
import org.fishwife.jrugged.ConstantFlowRegulatorExceptionMapper;
import org.fishwife.jrugged.FlowRateExceededException;
import org.fishwife.jrugged.ServiceWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantFlowRegulator
implements ServiceWrapper {
    private int requestPerSecondThreshold = -1;
    private long deltaWaitTimeMillis = 0L;
    private long lastRequestOccurance = 0L;
    ConstantFlowRegulatorExceptionMapper<? extends Exception> exceptionMapper;

    public ConstantFlowRegulator() {
    }

    public ConstantFlowRegulator(int requestsPerSecond) {
        this.requestPerSecondThreshold = requestsPerSecond;
        this.calculateDeltaWaitTime();
    }

    public ConstantFlowRegulator(int requestsPerSecond, ConstantFlowRegulatorExceptionMapper<? extends Exception> mapper) {
        this.requestPerSecondThreshold = requestsPerSecond;
        this.calculateDeltaWaitTime();
        this.exceptionMapper = mapper;
    }

    @Override
    public <T> T invoke(Callable<T> c) throws Exception {
        if (this.canProceed()) {
            return c.call();
        }
        throw this.mapException(new FlowRateExceededException());
    }

    @Override
    public void invoke(Runnable r) throws Exception {
        if (!this.canProceed()) {
            throw this.mapException(new FlowRateExceededException());
        }
        r.run();
    }

    @Override
    public <T> T invoke(Runnable r, T result) throws Exception {
        if (this.canProceed()) {
            r.run();
            return result;
        }
        throw this.mapException(new FlowRateExceededException());
    }

    protected synchronized boolean canProceed() {
        if (this.requestPerSecondThreshold == -1) {
            return true;
        }
        if (this.lastRequestOccurance == 0L) {
            this.lastRequestOccurance = System.currentTimeMillis();
            return true;
        }
        if (System.currentTimeMillis() - this.lastRequestOccurance > this.deltaWaitTimeMillis) {
            this.lastRequestOccurance = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public void setRequestPerSecondThreshold(int i) {
        this.requestPerSecondThreshold = i;
        this.calculateDeltaWaitTime();
    }

    public int getRequestPerSecondThreshold() {
        return this.requestPerSecondThreshold;
    }

    public ConstantFlowRegulatorExceptionMapper<? extends Exception> getExceptionMapper() {
        return this.exceptionMapper;
    }

    public void setExceptionMapper(ConstantFlowRegulatorExceptionMapper<? extends Exception> mapper) {
        this.exceptionMapper = mapper;
    }

    private void calculateDeltaWaitTime() {
        if (this.requestPerSecondThreshold > 0) {
            this.deltaWaitTimeMillis = 1000L / (long)this.requestPerSecondThreshold;
        }
    }

    private Exception mapException(FlowRateExceededException e) {
        if (this.exceptionMapper == null) {
            return e;
        }
        return this.exceptionMapper.map(this, e);
    }
}

