/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.internal.metrics.DiscardableMetricsProvider;
import com.hazelcast.internal.metrics.MetricsProvider;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.networking.IOThreadingModel;
import com.hazelcast.internal.networking.SocketChannelWrapper;
import com.hazelcast.internal.networking.SocketConnection;
import com.hazelcast.internal.networking.SocketReader;
import com.hazelcast.internal.networking.SocketWriter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ConnectionType;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.OutboundFrame;
import com.hazelcast.nio.tcp.TcpIpConnectionManager;
import com.hazelcast.nio.tcp.TcpIpConnectionMonitor;
import java.io.EOFException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.CancelledKeyException;
import java.util.concurrent.atomic.AtomicBoolean;

public final class TcpIpConnection
implements SocketConnection,
MetricsProvider,
DiscardableMetricsProvider {
    private final SocketChannelWrapper socketChannel;
    private final SocketReader socketReader;
    private final SocketWriter socketWriter;
    private final TcpIpConnectionManager connectionManager;
    private final AtomicBoolean alive = new AtomicBoolean(true);
    private final ILogger logger;
    private final int connectionId;
    private final IOService ioService;
    private Address endPoint;
    private TcpIpConnectionMonitor monitor;
    private volatile ConnectionType type = ConnectionType.NONE;
    private volatile Throwable closeCause;
    private volatile String closeReason;

    public TcpIpConnection(TcpIpConnectionManager connectionManager, int connectionId, SocketChannelWrapper socketChannel, IOThreadingModel ioThreadingModel) {
        this.connectionId = connectionId;
        this.connectionManager = connectionManager;
        this.ioService = connectionManager.getIoService();
        this.logger = this.ioService.getLoggingService().getLogger(TcpIpConnection.class);
        this.socketChannel = socketChannel;
        this.socketWriter = ioThreadingModel.newSocketWriter(this);
        this.socketReader = ioThreadingModel.newSocketReader(this);
    }

    @Override
    public void provideMetrics(MetricsRegistry registry) {
        Socket socket = this.socketChannel.socket();
        SocketAddress localSocketAddress = socket != null ? socket.getLocalSocketAddress() : null;
        SocketAddress remoteSocketAddress = socket != null ? socket.getRemoteSocketAddress() : null;
        String metricsId = localSocketAddress + "->" + remoteSocketAddress;
        registry.scanAndRegister(this.socketWriter, "tcp.connection[" + metricsId + "].out");
        registry.scanAndRegister(this.socketReader, "tcp.connection[" + metricsId + "].in");
    }

    @Override
    public void discardMetrics(MetricsRegistry registry) {
        registry.deregister(this.socketReader);
        registry.deregister(this.socketWriter);
    }

    @Override
    public SocketReader getSocketReader() {
        return this.socketReader;
    }

    @Override
    public SocketWriter getSocketWriter() {
        return this.socketWriter;
    }

    @Override
    public SocketChannelWrapper getSocketChannel() {
        return this.socketChannel;
    }

    @Override
    public ConnectionType getType() {
        return this.type;
    }

    @Override
    public void setType(ConnectionType type) {
        if (this.type == ConnectionType.NONE) {
            this.type = type;
        }
    }

    @Probe
    private int getConnectionType() {
        ConnectionType t = this.type;
        return t == null ? -1 : t.ordinal();
    }

    public TcpIpConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socketChannel.socket().getInetAddress();
    }

    @Override
    public int getPort() {
        return this.socketChannel.socket().getPort();
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return (InetSocketAddress)this.socketChannel.socket().getRemoteSocketAddress();
    }

    @Override
    public boolean isAlive() {
        return this.alive.get();
    }

    @Override
    public long lastWriteTimeMillis() {
        return this.socketWriter.lastWriteTimeMillis();
    }

    @Override
    public long lastReadTimeMillis() {
        return this.socketReader.lastReadTimeMillis();
    }

    @Override
    public Address getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(Address endPoint) {
        this.endPoint = endPoint;
    }

    public void setMonitor(TcpIpConnectionMonitor monitor) {
        this.monitor = monitor;
    }

    public TcpIpConnectionMonitor getMonitor() {
        return this.monitor;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.socketChannel.socket().setSendBufferSize(size);
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.socketChannel.socket().setReceiveBufferSize(size);
    }

    @Override
    public boolean isClient() {
        ConnectionType t = this.type;
        return t != null && t != ConnectionType.NONE && t.isClient();
    }

    public void start() {
        this.socketReader.init();
    }

    @Override
    public boolean write(OutboundFrame frame) {
        if (!this.alive.get()) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Connection is closed, won't write packet -> " + frame);
            }
            return false;
        }
        this.socketWriter.write(frame);
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TcpIpConnection)) {
            return false;
        }
        TcpIpConnection that = (TcpIpConnection)o;
        return this.connectionId == that.getConnectionId();
    }

    public int hashCode() {
        return this.connectionId;
    }

    @Override
    public void close(String reason, Throwable cause) {
        if (!this.alive.compareAndSet(true, false)) {
            return;
        }
        this.closeCause = cause;
        this.closeReason = reason;
        this.logClose();
        try {
            if (this.socketChannel != null && this.socketChannel.isOpen()) {
                this.socketReader.close();
                this.socketWriter.close();
                this.socketChannel.close();
            }
        }
        catch (Exception e) {
            this.logger.warning(e);
        }
        this.connectionManager.onClose(this);
        this.ioService.onDisconnect(this.endPoint, cause);
        if (cause != null && this.monitor != null) {
            this.monitor.onError(cause);
        }
    }

    private void logClose() {
        String message = this.toString() + " closed. Reason: ";
        message = this.closeReason != null ? message + this.closeReason : (this.closeCause != null ? message + this.closeCause.getClass().getName() + "[" + this.closeCause.getMessage() + "]" : message + "Socket explicitly closed");
        if (this.ioService.isActive()) {
            if (this.closeCause == null || this.closeCause instanceof EOFException || this.closeCause instanceof CancelledKeyException) {
                this.logger.info(message);
            } else {
                this.logger.warning(message, this.closeCause);
            }
        } else if (this.closeCause == null) {
            this.logger.finest(message);
        } else {
            this.logger.finest(message, this.closeCause);
        }
    }

    @Override
    public Throwable getCloseCause() {
        return this.closeCause;
    }

    @Override
    public String getCloseReason() {
        if (this.closeReason == null) {
            return this.closeCause == null ? null : this.closeCause.getMessage();
        }
        return this.closeReason;
    }

    public String toString() {
        Socket socket = this.socketChannel.socket();
        SocketAddress localSocketAddress = socket != null ? socket.getLocalSocketAddress() : null;
        SocketAddress remoteSocketAddress = socket != null ? socket.getRemoteSocketAddress() : null;
        return "Connection[id=" + this.connectionId + ", " + localSocketAddress + "->" + remoteSocketAddress + ", endpoint=" + this.endPoint + ", alive=" + this.alive + ", type=" + (Object)((Object)this.type) + "]";
    }
}

