/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache.publisher;

import com.hazelcast.core.IFunction;
import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.map.impl.querycache.Registry;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class QueryCacheListenerRegistry
implements Registry<String, String> {
    private ConstructorFunction<String, String> registryConstructorFunction = new ConstructorFunction<String, String>(){

        @Override
        public String createNew(String ignored) {
            IFunction<String, String> registration = QueryCacheListenerRegistry.this.context.getPublisherContext().getListenerRegistrator();
            return registration.apply(QueryCacheListenerRegistry.this.mapName);
        }
    };
    private final String mapName;
    private final QueryCacheContext context;
    private final ConcurrentMap<String, String> listeners;

    public QueryCacheListenerRegistry(QueryCacheContext context, String mapName) {
        this.context = context;
        this.mapName = mapName;
        this.listeners = new ConcurrentHashMap<String, String>();
    }

    @Override
    public String getOrCreate(String cacheName) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.listeners, cacheName, this.registryConstructorFunction);
    }

    @Override
    public String getOrNull(String cacheName) {
        return (String)this.listeners.get(cacheName);
    }

    @Override
    public Map<String, String> getAll() {
        return Collections.unmodifiableMap(this.listeners);
    }

    @Override
    public String remove(String cacheName) {
        return (String)this.listeners.remove(cacheName);
    }
}

