/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.PartitioningStrategyConfig;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.ExceptionUtil;
import java.util.concurrent.ConcurrentHashMap;

public final class PartitioningStrategyFactory {
    private static final ConcurrentHashMap<String, PartitioningStrategy> CACHE = new ConcurrentHashMap();

    private PartitioningStrategyFactory() {
    }

    public static PartitioningStrategy getPartitioningStrategy(NodeEngine nodeEngine, String mapName, PartitioningStrategyConfig config) {
        PartitioningStrategy strategy = null;
        if (config != null && (strategy = config.getPartitioningStrategy()) == null) {
            if (CACHE.containsKey(mapName)) {
                strategy = CACHE.get(mapName);
            } else if (config.getPartitioningStrategyClass() != null) {
                try {
                    strategy = (PartitioningStrategy)ClassLoaderUtil.newInstance(nodeEngine.getConfigClassLoader(), config.getPartitioningStrategyClass());
                    CACHE.put(mapName, strategy);
                }
                catch (Exception e) {
                    throw ExceptionUtil.rethrow(e);
                }
            }
        }
        return strategy;
    }

    public static void removePartitioningStrategyFromCache(String mapName) {
        CACHE.remove(mapName);
    }
}

