/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import com.hazelcast.internal.diagnostics.DiagnosticsLogWriter;
import com.hazelcast.util.StringUtil;

class MultiLineDiagnosticsLogWriter
extends DiagnosticsLogWriter {
    private static final String STR_LONG_MIN_VALUE = String.format(StringUtil.LOCALE_INTERNAL, "%,d", Long.MIN_VALUE);
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final String[] INDENTS = new String[]{StringUtil.LINE_SEPARATOR + "                          ", StringUtil.LINE_SEPARATOR + "                                  ", StringUtil.LINE_SEPARATOR + "                                          ", StringUtil.LINE_SEPARATOR + "                                                  "};
    private final StringBuffer tmpSb = new StringBuffer();

    MultiLineDiagnosticsLogWriter() {
    }

    @Override
    public void startSection(String name) {
        if (this.sectionLevel == -1) {
            this.appendDateTime();
            this.sb.append(' ');
        }
        if (this.sectionLevel >= 0) {
            this.sb.append(INDENTS[this.sectionLevel]);
        }
        this.sb.append(name);
        this.sb.append('[');
        ++this.sectionLevel;
    }

    @Override
    public void endSection() {
        this.sb.append(']');
        --this.sectionLevel;
        if (this.sectionLevel == -1) {
            this.sb.append(StringUtil.LINE_SEPARATOR);
        }
    }

    @Override
    public void writeEntry(String s) {
        this.sb.append(INDENTS[this.sectionLevel]);
        this.sb.append(s);
    }

    @Override
    public void writeKeyValueEntry(String key, String value) {
        this.writeKeyValueHead(key);
        this.sb.append(value);
    }

    void writeLong(long value) {
        if (value == Long.MIN_VALUE) {
            this.sb.append(STR_LONG_MIN_VALUE);
            return;
        }
        if (value < 0L) {
            this.sb.append('-');
            value = -value;
        }
        int digitsWithoutComma = 0;
        this.tmpSb.setLength(0);
        do {
            if (++digitsWithoutComma == 4) {
                this.tmpSb.append(',');
                digitsWithoutComma = 1;
            }
            int mod = (int)(value % 10L);
            this.tmpSb.append(DIGITS[mod]);
        } while ((value /= 10L) > 0L);
        for (int k = this.tmpSb.length() - 1; k >= 0; --k) {
            char c = this.tmpSb.charAt(k);
            this.sb.append(c);
        }
    }

    @Override
    public void writeKeyValueEntry(String key, double value) {
        this.writeKeyValueHead(key);
        this.sb.append(value);
    }

    @Override
    public void writeKeyValueEntry(String key, long value) {
        this.writeKeyValueHead(key);
        this.writeLong(value);
    }

    @Override
    public void writeKeyValueEntry(String key, boolean value) {
        this.writeKeyValueHead(key);
        this.sb.append(value);
    }

    private void writeKeyValueHead(String key) {
        this.sb.append(INDENTS[this.sectionLevel]);
        this.sb.append(key);
        this.sb.append('=');
    }
}

