/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi;

import com.hazelcast.cache.impl.nearcache.NearCacheManager;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.ClientTransactionManagerService;
import com.hazelcast.client.spi.ProxyManager;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.spi.serialization.SerializationService;

public final class ClientContext {
    private final SerializationService serializationService;
    private final ClientClusterService clusterService;
    private final ClientPartitionService partitionService;
    private final ClientInvocationService invocationService;
    private final ClientExecutionService executionService;
    private final ClientListenerService listenerService;
    private final NearCacheManager nearCacheManager;
    private final ClientTransactionManagerService transactionManager;
    private final ProxyManager proxyManager;
    private final ClientConfig clientConfig;
    private final LoggingService loggingService;

    ClientContext(HazelcastClientInstanceImpl client, ProxyManager proxyManager) {
        this.serializationService = client.getSerializationService();
        this.clusterService = client.getClientClusterService();
        this.partitionService = client.getClientPartitionService();
        this.invocationService = client.getInvocationService();
        this.executionService = client.getClientExecutionService();
        this.listenerService = client.getListenerService();
        this.nearCacheManager = client.getNearCacheManager();
        this.proxyManager = proxyManager;
        this.clientConfig = client.getClientConfig();
        this.transactionManager = client.getTransactionManager();
        this.loggingService = client.getLoggingService();
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.proxyManager.getHazelcastInstance();
    }

    public SerializationService getSerializationService() {
        return this.serializationService;
    }

    public ClientClusterService getClusterService() {
        return this.clusterService;
    }

    public ClientPartitionService getPartitionService() {
        return this.partitionService;
    }

    public ClientInvocationService getInvocationService() {
        return this.invocationService;
    }

    public ClientTransactionManagerService getTransactionManager() {
        return this.transactionManager;
    }

    public ClientExecutionService getExecutionService() {
        return this.executionService;
    }

    public ClientListenerService getListenerService() {
        return this.listenerService;
    }

    public NearCacheManager getNearCacheManager() {
        return this.nearCacheManager;
    }

    public LoggingService getLoggingService() {
        return this.loggingService;
    }

    public void removeProxy(ClientProxy proxy) {
        this.proxyManager.removeProxy(proxy.getServiceName(), proxy.getDistributedObjectName());
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public boolean isActive() {
        return this.getHazelcastInstance().getLifecycleService().isRunning();
    }
}

