/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheCreateConfigCodec;
import com.hazelcast.client.impl.protocol.codec.CacheGetConfigCodec;
import com.hazelcast.client.impl.protocol.codec.CacheManagementConfigCodec;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.core.Member;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.FutureUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

final class ClientCacheHelper {
    private ClientCacheHelper() {
    }

    static <K, V> CacheConfig<K, V> getCacheConfig(HazelcastClientInstanceImpl client, String cacheName, String simpleCacheName) {
        ClientMessage request = CacheGetConfigCodec.encodeRequest(cacheName, simpleCacheName);
        try {
            int partitionId = client.getClientPartitionService().getPartitionId(cacheName);
            ClientInvocation clientInvocation = new ClientInvocation(client, request, partitionId);
            ClientInvocationFuture future = clientInvocation.invoke();
            ClientMessage responseMessage = (ClientMessage)future.get();
            SerializationService serializationService = client.getSerializationService();
            return (CacheConfig)serializationService.toObject(CacheGetConfigCodec.decodeResponse((ClientMessage)responseMessage).response);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    static <K, V> CacheConfig<K, V> createCacheConfig(HazelcastClientInstanceImpl client, ConcurrentMap<String, CacheConfig> configs, String cacheName, CacheConfig<K, V> newCacheConfig, boolean createAlsoOnOthers, boolean syncCreate) {
        try {
            CacheConfig currentCacheConfig = (CacheConfig)configs.get(cacheName);
            int partitionId = client.getClientPartitionService().getPartitionId(newCacheConfig.getNameWithPrefix());
            Object newCacheConfigData = client.getSerializationService().toData(newCacheConfig);
            ClientMessage request = CacheCreateConfigCodec.encodeRequest(newCacheConfigData, createAlsoOnOthers);
            ClientInvocation clientInvocation = new ClientInvocation(client, request, partitionId);
            ClientInvocationFuture future = clientInvocation.invoke();
            if (syncCreate) {
                ClientMessage response = (ClientMessage)future.get();
                Data data = CacheCreateConfigCodec.decodeResponse((ClientMessage)response).response;
                return (CacheConfig)client.getSerializationService().toObject(data);
            }
            return currentCacheConfig;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    static void enableStatisticManagementOnNodes(HazelcastClientInstanceImpl client, String cacheName, boolean statOrMan, boolean enabled) {
        Collection<Member> members = client.getClientClusterService().getMemberList();
        ArrayList<Future> futures = new ArrayList<Future>();
        for (Member member : members) {
            try {
                Address address = member.getAddress();
                ClientMessage request = CacheManagementConfigCodec.encodeRequest(cacheName, statOrMan, enabled, address);
                ClientInvocation clientInvocation = new ClientInvocation(client, request, address);
                ClientInvocationFuture future = clientInvocation.invoke();
                futures.add(future);
            }
            catch (Exception e) {
                ExceptionUtil.sneakyThrow(e);
            }
        }
        FutureUtil.waitWithDeadline(futures, 60L, TimeUnit.SECONDS);
    }
}

