/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.client.util.AddressHelper;
import com.hazelcast.nio.Address;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class DefaultAddressProvider
implements AddressProvider {
    private ClientNetworkConfig networkConfig;
    private boolean noOtherAddressProviderExist;

    public DefaultAddressProvider(ClientNetworkConfig networkConfig, boolean noOtherAddressProviderExist) {
        this.networkConfig = networkConfig;
        this.noOtherAddressProviderExist = noOtherAddressProviderExist;
    }

    @Override
    public Collection<Address> loadAddresses() {
        List<String> addresses = this.networkConfig.getAddresses();
        if (addresses.isEmpty() && this.noOtherAddressProviderExist) {
            addresses.add("127.0.0.1");
        }
        LinkedList<Address> possibleAddresses = new LinkedList<Address>();
        for (String address : addresses) {
            possibleAddresses.addAll(AddressHelper.getSocketAddresses(address));
        }
        return possibleAddresses;
    }
}

