/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.groupware.i18n;

import com.openexchange.i18n.LocalizableStrings;

/**
 * FolderStrings contains English translations for string constants related to folder module
 *
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 */
public class FolderStrings implements LocalizableStrings {

    // Name of the parent folder for the private user folders.
    public static final String SYSTEM_PRIVATE_FOLDER_NAME = "Private folders";

    public static final String SYSTEM_PUBLIC_FOLDER_NAME = "Public folders";

    public static final String SYSTEM_SHARED_FOLDER_NAME = "Shared folders";

    public static final String SYSTEM_FOLDER_NAME = "System";

    /*public static final String SYSTEM_GLOBAL_FOLDER_NAME = "Shared address book";*/ // finally dropped

    public static final String SYSTEM_LDAP_FOLDER_NAME = "Global address book";

    public static final String SYSTEM_OX_FOLDER_NAME = "OX folders";

    public static final String SYSTEM_INFOSTORE_FOLDER_NAME = "Infostore";

    public static final String SYSTEM_USER_INFOSTORE_FOLDER_NAME = "Userstore";

    public static final String SYSTEM_PUBLIC_INFOSTORE_FOLDER_NAME = "Public infostore";

    public static final String SYSTEM_TRASH_INFOSTORE_FOLDER_NAME = "Trash";

    public static final String VIRTUAL_LIST_TASK_FOLDER_NAME = "Other task folders";

    public static final String VIRTUAL_LIST_CALENDAR_FOLDER_NAME = "Other calendar folders";

    public static final String VIRTUAL_LIST_CONTACT_FOLDER_NAME = "Other contact folders";

    public static final String VIRTUAL_LIST_INFOSTORE_FOLDER_NAME = "Other infostore folders";

    public static final String DEFAULT_TASK_FOLDER_NAME = "Tasks";

    public static final String DEFAULT_CALENDAR_FOLDER_NAME = "Calendar";

    public static final String DEFAULT_CONTACT_FOLDER_NAME = "Contacts";

    public static final String DEFAULT_CONTACT_COLLECT_FOLDER_NAME = "Collected addresses";

    public static final String DEFAULT_EMAIL_ATTACHMENTS_FOLDER_NAME = "E-Mail attachments";

    public static final String DEFAULT_FILES_FOLDER_NAME = "My files";

    public static final String SYSTEM_FILES_FOLDER_NAME = "Drive";

    public static final String SYSTEM_USER_FILES_FOLDER_NAME = "Shared files";

    public static final String SYSTEM_PUBLIC_FILES_FOLDER_NAME = "Public files";

    public static final String SYSTEM_TRASH_FILES_FOLDER_NAME = "Trash";

    public static final String VIRTUAL_LIST_FILES_FOLDER_NAME = "Other files";

    public static final String SYSTEM_USER_PICTURES_FOLDER_NAME = "Pictures";

    public static final String SYSTEM_USER_DOCUMENTS_FOLDER_NAME = "Documents";

    public static final String SYSTEM_USER_MUSIC_FOLDER_NAME = "Music";

    public static final String SYSTEM_USER_VIDEOS_FOLDER_NAME = "Videos";

    public static final String SYSTEM_USER_TEMPLATES_FOLDER_NAME = "Templates";

    // -----------------------------------------------------------------------------------------------------

    public static final String FIELD_FOLDER_NAME = "Folder name";

}
