/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.stringsearch;

import com.eaio.stringsearch.CharIntMap;
import com.eaio.stringsearch.MismatchSearch;
import java.lang.reflect.Field;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public abstract class StringSearch {
    private static final int CROSSOVER_MACOSX = 50;
    private static int crossover = 0;
    static StringAccess activeStringAccess;

    static {
        String shortString = ".";
        ".".hashCode();
        Field value = null;
        Field offset = null;
        try {
            Field[] valueOffset = AccessController.doPrivileged(new PrivilegedExceptionAction<Field[]>(){

                @Override
                public Field[] run() throws Exception {
                    Field[] stringFields = ".".getClass().getDeclaredFields();
                    Class<?> charArray = new char[0].getClass();
                    Field val = null;
                    Field off = null;
                    int i = 0;
                    while (i < stringFields.length) {
                        if (stringFields[i].getType() == charArray) {
                            val = stringFields[i];
                            val.setAccessible(true);
                        } else if (stringFields[i].getType() == Integer.TYPE) {
                            stringFields[i].setAccessible(true);
                            if (stringFields[i].getInt(".") == 0) {
                                off = stringFields[i];
                            }
                        }
                        ++i;
                    }
                    return new Field[]{val, off};
                }
            });
            value = valueOffset[0];
            offset = valueOffset[1];
        }
        catch (AccessControlException valueOffset) {
        }
        catch (PrivilegedActionException valueOffset) {
            // empty catch block
        }
        if (value != null && offset != null) {
            activeStringAccess = new ReflectionStringAccess(value, offset);
            try {
                String vendor = System.getProperty("java.vendor", "");
                char v = vendor.charAt(0);
                if (v == 'I' || v == 'S') {
                    crossover = 0;
                }
                if (System.getProperty("mrj.version") != null) {
                    crossover = 50;
                }
            }
            catch (SecurityException securityException) {}
        } else {
            activeStringAccess = new StringAccess();
        }
    }

    public static boolean usesReflection() {
        return activeStringAccess instanceof ReflectionStringAccess;
    }

    public static char[] getChars(String s) {
        return activeStringAccess.getChars(s);
    }

    protected StringSearch() {
    }

    public abstract Object processBytes(byte[] var1);

    public abstract Object processChars(char[] var1);

    public Object processString(String pattern) {
        return this.processChars(StringSearch.getChars(pattern));
    }

    public final int searchBytes(byte[] text, byte[] pattern) {
        return this.searchBytes(text, 0, text.length, pattern, this.processBytes(pattern));
    }

    public final int searchBytes(byte[] text, byte[] pattern, Object processed) {
        return this.searchBytes(text, 0, text.length, pattern, processed);
    }

    public final int searchBytes(byte[] text, int textStart, byte[] pattern) {
        return this.searchBytes(text, textStart, text.length, pattern, this.processBytes(pattern));
    }

    public final int searchBytes(byte[] text, int textStart, byte[] pattern, Object processed) {
        return this.searchBytes(text, textStart, text.length, pattern, processed);
    }

    public final int searchBytes(byte[] text, int textStart, int textEnd, byte[] pattern) {
        return this.searchBytes(text, textStart, textEnd, pattern, this.processBytes(pattern));
    }

    public abstract int searchBytes(byte[] var1, int var2, int var3, byte[] var4, Object var5);

    public final int searchChars(char[] text, char[] pattern) {
        return this.searchChars(text, 0, text.length, pattern, this.processChars(pattern));
    }

    public final int searchChars(char[] text, char[] pattern, Object processed) {
        return this.searchChars(text, 0, text.length, pattern, processed);
    }

    public final int searchChars(char[] text, int textStart, char[] pattern) {
        return this.searchChars(text, textStart, text.length, pattern, this.processChars(pattern));
    }

    public final int searchChars(char[] text, int textStart, char[] pattern, Object processed) {
        return this.searchChars(text, textStart, text.length, pattern, processed);
    }

    public final int searchChars(char[] text, int textStart, int textEnd, char[] pattern) {
        return this.searchChars(text, textStart, textEnd, pattern, this.processChars(pattern));
    }

    public abstract int searchChars(char[] var1, int var2, int var3, char[] var4, Object var5);

    public final int searchString(String text, String pattern) {
        return this.searchString(text, 0, text.length(), pattern);
    }

    public final int searchString(String text, String pattern, Object processed) {
        return this.searchString(text, 0, text.length(), pattern, processed);
    }

    public final int searchString(String text, int textStart, String pattern) {
        return this.searchString(text, textStart, text.length(), pattern);
    }

    public final int searchString(String text, int textStart, String pattern, Object processed) {
        return this.searchString(text, textStart, text.length(), pattern, processed);
    }

    public final int searchString(String text, int textStart, int textEnd, String pattern) {
        return activeStringAccess.searchString(text, textStart, textEnd, pattern, this);
    }

    public final int searchString(String text, int textStart, int textEnd, String pattern, Object processed) {
        return activeStringAccess.searchString(text, textStart, textEnd, pattern, processed, this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass().getName().equals(obj.getClass().getName());
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public String toString() {
        return this.getClass().getName();
    }

    protected final CharIntMap createCharIntMap(char[] pattern, int defaultValue) {
        return this.createCharIntMap(pattern, pattern.length, defaultValue);
    }

    protected final CharIntMap createCharIntMap(char[] pattern, int patternEnd, int defaultValue) {
        char min = '\uffff';
        char max = '\u0000';
        int i = 0;
        while (i < patternEnd) {
            max = max > pattern[i] ? max : pattern[i];
            min = min < pattern[i] ? min : pattern[i];
            ++i;
        }
        return new CharIntMap(max - min + 1, min, defaultValue);
    }

    protected final int index(byte idx) {
        return idx & 0xFF;
    }

    static class ReflectionStringAccess
    extends StringAccess {
        private Field value;
        private Field offset;

        private ReflectionStringAccess(Field value, Field offset) {
            super(null, null);
            this.value = value;
            this.offset = offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        int searchString(String text, int textStart, int textEnd, String pattern, Object processed, StringSearch instance) {
            int l = text.length();
            if (l > crossover) {
                try {
                    int o = this.offset.getInt(text);
                    char[] t = (char[])this.value.get(text);
                    return instance.searchChars(t, textStart + o, textEnd + o, this.getChars(pattern), processed) - o;
                }
                catch (IllegalAccessException ex) {
                    StringAccess stringAccess = activeStringAccess;
                    synchronized (stringAccess) {
                        activeStringAccess = new StringAccess();
                    }
                }
            }
            return super.searchString(text, textStart, textEnd, pattern, processed, instance);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        int searchString(String text, int textStart, int textEnd, String pattern, StringSearch instance) {
            int l = text.length();
            if (l > crossover) {
                try {
                    int o = this.offset.getInt(text);
                    char[] t = (char[])this.value.get(text);
                    return instance.searchChars(t, textStart + o, textEnd + o, this.getChars(pattern)) - o;
                }
                catch (IllegalAccessException ex) {
                    StringAccess stringAccess = activeStringAccess;
                    synchronized (stringAccess) {
                        activeStringAccess = new StringAccess();
                    }
                }
            }
            return super.searchString(text, textStart, textEnd, pattern, instance);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        int[] searchString(String text, int textStart, int textEnd, String pattern, int k, MismatchSearch instance) {
            int l = text.length();
            if (l > crossover) {
                try {
                    int o = this.offset.getInt(text);
                    char[] t = (char[])this.value.get(text);
                    int[] r = instance.searchChars(t, textStart + o, textEnd + o, this.getChars(pattern), k);
                    if (r[0] != -1) {
                        r[0] = r[0] - o;
                    }
                    return r;
                }
                catch (IllegalAccessException ex) {
                    StringAccess stringAccess = activeStringAccess;
                    synchronized (stringAccess) {
                        activeStringAccess = new StringAccess();
                    }
                }
            }
            return super.searchString(text, textStart, textEnd, pattern, k, instance);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        int[] searchString(String text, int textStart, int textEnd, String pattern, Object processed, int k, MismatchSearch instance) {
            int l = text.length();
            if (l > crossover) {
                try {
                    int o = this.offset.getInt(text);
                    char[] t = (char[])this.value.get(text);
                    int[] r = instance.searchChars(t, textStart + o, textEnd + o, this.getChars(pattern), processed, k);
                    if (r[0] != -1) {
                        r[0] = r[0] - o;
                    }
                    return r;
                }
                catch (IllegalAccessException ex) {
                    StringAccess stringAccess = activeStringAccess;
                    synchronized (stringAccess) {
                        activeStringAccess = new StringAccess();
                    }
                }
            }
            return super.searchString(text, textStart, textEnd, pattern, processed, k, instance);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        char[] getChars(String s) {
            int l = s.length();
            if (l > crossover) {
                try {
                    if (this.offset.getInt(s) != 0) {
                        return super.getChars(s);
                    }
                    char[] c = (char[])this.value.get(s);
                    if (c.length != l) {
                        return super.getChars(s);
                    }
                    return c;
                }
                catch (IllegalAccessException ex) {
                    StringAccess stringAccess = activeStringAccess;
                    synchronized (stringAccess) {
                        activeStringAccess = new StringAccess();
                    }
                }
            }
            return super.getChars(s);
        }
    }

    static class StringAccess {
        private StringAccess() {
        }

        int searchString(String text, int textStart, int textEnd, String pattern, Object processed, StringSearch instance) {
            return instance.searchChars(text.toCharArray(), textStart, textEnd, pattern.toCharArray(), processed);
        }

        int searchString(String text, int textStart, int textEnd, String pattern, StringSearch instance) {
            return instance.searchChars(text.toCharArray(), textStart, textEnd, pattern.toCharArray());
        }

        int[] searchString(String text, int textStart, int textEnd, String pattern, int k, MismatchSearch instance) {
            return instance.searchChars(text.toCharArray(), textStart, textEnd, pattern.toCharArray(), k);
        }

        int[] searchString(String text, int textStart, int textEnd, String pattern, Object processed, int k, MismatchSearch instance) {
            return instance.searchChars(text.toCharArray(), textStart, textEnd, pattern.toCharArray(), processed, k);
        }

        char[] getChars(String s) {
            return s.toCharArray();
        }

        /* synthetic */ StringAccess(StringAccess stringAccess, StringAccess stringAccess2) {
            this();
        }
    }
}

