/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.templating.impl;

import com.openexchange.groupware.infostore.DocumentMetadata;

public class DocumentMetadataMatcher {
    private DocumentMetadata bestMatch;
    private final String name;
    private int score;

    public DocumentMetadataMatcher(String name) {
        this.name = name;
        this.score = 0;
    }

    public boolean hasPerfectMatch() {
        return this.score > 10;
    }

    public DocumentMetadata getBestMatch() {
        return this.bestMatch;
    }

    public void propose(DocumentMetadata document) {
        String filenameWithoutExtension;
        int newScore = 0;
        String fileName = document.getFileName();
        if (fileName == null) {
            return;
        }
        if (fileName.equals(this.name)) {
            newScore = 100;
        }
        if (fileName.indexOf(46) >= 0 && (filenameWithoutExtension = fileName.substring(0, fileName.lastIndexOf(46))).equals(this.name)) {
            newScore = 5;
        }
        if (document.getTitle() != null && document.getTitle().equals(this.name)) {
            newScore = 7;
        }
        if (newScore > this.score) {
            this.score = newScore;
            this.bestMatch = document;
        }
    }
}

