/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaSerializable;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.ArrayElement;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSData;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.OutOfTypeSystemData;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.Pair;
import org.apache.uima.internal.util.StringUtils;
import org.apache.uima.jcas.cas.BooleanArray;
import org.apache.uima.jcas.cas.ByteArray;
import org.apache.uima.jcas.cas.DoubleArray;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.FloatArray;
import org.apache.uima.jcas.cas.IntegerArray;
import org.apache.uima.jcas.cas.LongArray;
import org.apache.uima.jcas.cas.ShortArray;
import org.apache.uima.jcas.cas.Sofa;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.util.XMLSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XCASSerializer {
    private int numChildren;
    public static final String casTagName = "CAS";
    public static final String VERSION_ATTR = "version";
    public static final String CURRENT_VERSION = "2";
    public static final String DEFAULT_DOC_TYPE_NAME = "uima.tcas.Document";
    public static final String DEFAULT_DOC_TEXT_FEAT = "text";
    public static final String INDEXED_ATTR_NAME = "_indexed";
    public static final String REF_PREFIX = "_ref_";
    public static final String ID_ATTR_NAME = "_id";
    public static final String CONTENT_ATTR_NAME = "_content";
    public static final String ARRAY_SIZE_ATTR = "size";
    public static final String ARRAY_ELEMENT_TAG = "i";
    public static final String TRUE_VALUE = "true";
    private TypeSystemImpl ts;
    private String[] featureNames;
    private String docTypeName = "uima.tcas.Document";
    private String docTextFeature = "text";

    public int getNumChildren() {
        return this.numChildren;
    }

    private String getXCasElementName(String aTagName) {
        if (aTagName.indexOf(58) == -1 && aTagName.indexOf(45) == -1) {
            return aTagName;
        }
        return StringUtils.replaceAll(StringUtils.replaceAll(aTagName, ":", "_colon_"), "-", "_dash_");
    }

    public XCASSerializer(TypeSystem ts, UimaContext uimaContext) {
        this.ts = (TypeSystemImpl)ts;
        int featArraySize = this.ts.getNumberOfFeatures() + 1;
        this.featureNames = new String[featArraySize];
        Iterator<Feature> it = this.ts.getFeatures();
        while (it.hasNext()) {
            FeatureImpl feat = (FeatureImpl)it.next();
            String featName = feat.getRange().isPrimitive() ? feat.getShortName() : REF_PREFIX + feat.getShortName();
            this.featureNames[feat.getCode()] = featName;
        }
    }

    public XCASSerializer(TypeSystem ts) {
        this(ts, null);
    }

    public void serialize(CAS cas, ContentHandler contentHandler) throws IOException, SAXException {
        this.serialize(cas, contentHandler, true);
    }

    public void serialize(CAS cas, ContentHandler contentHandler, boolean encodeDoc) throws IOException, SAXException {
        this.serialize(cas, contentHandler, encodeDoc, null);
    }

    public void serialize(CAS cas, ContentHandler contentHandler, boolean encodeDoc, OutOfTypeSystemData outOfTypeSystemData) throws IOException, SAXException {
        contentHandler.startDocument();
        XCASDocSerializer ser = new XCASDocSerializer(contentHandler, ((CASImpl)cas).getBaseCAS());
        ser.serialize(encodeDoc, outOfTypeSystemData);
        contentHandler.endDocument();
    }

    public String getDocumentTypeName() {
        return this.docTypeName;
    }

    public void setDocumentTypeName(String aDocTypeName) {
        this.docTypeName = aDocTypeName;
    }

    public String getDocumentTextFeature() {
        return this.docTextFeature;
    }

    public void setDocumentTextFeature(String aDocTextFeature) {
        this.docTextFeature = aDocTextFeature;
    }

    public static void serialize(CAS aCAS, OutputStream aStream) throws SAXException, IOException {
        XCASSerializer.serialize(aCAS, aStream, false);
    }

    public static void serialize(CAS aCAS, OutputStream aStream, boolean isFormattedOutput) throws SAXException, IOException {
        XCASSerializer xcasSerializer = new XCASSerializer(aCAS.getTypeSystem());
        XMLSerializer sax2xml = new XMLSerializer(aStream, isFormattedOutput);
        xcasSerializer.serialize(aCAS, sax2xml.getContentHandler());
    }

    private class XCASDocSerializer {
        private ContentHandler ch;
        private CASImpl cas;
        private final Map<TOP, Integer> queued = new IdentityHashMap<TOP, Integer>();
        private static final int NOT_INDEXED = -1;
        private static final int MULTIPLY_INDEXED = -2;
        private static final int INVALID_INDEX = -3;
        private final Map<TOP, Integer> duplicates = new IdentityHashMap<TOP, Integer>();
        int numDuplicates;
        final List<IntVector> dupVectors = new ArrayList<IntVector>();
        private final List<TOP> indexedFSs = new ArrayList<TOP>();
        private final IntVector indexReps = new IntVector();
        private final Deque<TOP> queue = new ArrayDeque<TOP>();
        private final AttributesImpl emptyAttrs = new AttributesImpl();
        private AttributesImpl workAttrs = new AttributesImpl();
        private static final String cdataType = "CDATA";
        private int fsCount = 0;
        private OutOfTypeSystemData mOutOfTypeSystemData;
        private static final int KEY_AND_VALUE_MATCH = 1;
        private static final int KEY_ONLY_MATCH = -1;
        private static final int KEY_NOT_FOUND = 0;

        private XCASDocSerializer(ContentHandler ch, CASImpl cas) {
            this.ch = ch;
            this.cas = cas;
            this.numDuplicates = 0;
        }

        private boolean enqueue(TOP fs) {
            if (-1 == this.isQueued(fs, -3)) {
                return false;
            }
            int typeCode = fs._getTypeCode();
            this.queued.put(fs, -1);
            this.queue.push(fs);
            int typeClass = this.classifyType(fs._getTypeImpl());
            if (typeClass == 8) {
                if (this.mOutOfTypeSystemData != null) {
                    this.enqueueOutOfTypeSystemFeatures(fs);
                }
                this.enqueueFeatures(fs, typeCode);
            } else if (typeClass == 7) {
                this.enqueueFSArray((FSArray)fs);
            }
            return true;
        }

        private void enqueueIndexed(TOP fs, int indexRep) {
            int status = this.isQueued(fs, indexRep);
            switch (status) {
                case 0: {
                    this.queued.put(fs, indexRep);
                    this.indexedFSs.add(fs);
                    this.indexReps.add(indexRep);
                    break;
                }
                case 1: {
                    break;
                }
                case -1: {
                    int prevIndex = this.queued.get(fs);
                    if (-1 == prevIndex) {
                        this.queued.put(fs, indexRep);
                        break;
                    }
                    if (-2 == prevIndex) {
                        int thisDup = this.duplicates.get(fs);
                        this.dupVectors.get(thisDup).add(indexRep);
                        break;
                    }
                    this.duplicates.put(fs, this.numDuplicates);
                    this.dupVectors.add(new IntVector());
                    this.dupVectors.get(this.numDuplicates).add(prevIndex);
                    this.dupVectors.get(this.numDuplicates).add(indexRep);
                    ++this.numDuplicates;
                    this.queued.put(fs, -2);
                }
            }
        }

        private int isQueued(TOP fs, int value) {
            Integer v = this.queued.get(fs);
            return null == v ? 0 : (value == v ? 1 : -1);
        }

        private void serialize(boolean encodeDoc, OutOfTypeSystemData outOfTypeSystemData) throws IOException, SAXException {
            this.mOutOfTypeSystemData = outOfTypeSystemData;
            int iElementCount = 0;
            this.enqueueIndexed();
            this.enqueueFeaturesOfIndexed();
            if (outOfTypeSystemData != null) {
                int nextId = this.cas.getLastUsedFsId() + 1;
                for (FSData fs : outOfTypeSystemData.fsList) {
                    String newId = Integer.toString(nextId++);
                    outOfTypeSystemData.idMap.put(fs.id, newId);
                    fs.id = newId;
                }
                iElementCount += outOfTypeSystemData.fsList.size();
                this.enqueueOutOfTypeSystemData(outOfTypeSystemData);
            }
            iElementCount += this.indexedFSs.size();
            AttributesImpl rootAttrs = new AttributesImpl();
            rootAttrs.addAttribute("", XCASSerializer.VERSION_ATTR, XCASSerializer.VERSION_ATTR, cdataType, XCASSerializer.CURRENT_VERSION);
            this.startElement(XCASSerializer.casTagName, rootAttrs, iElementCount += this.queue.size());
            this.encodeIndexed();
            this.encodeQueued();
            if (outOfTypeSystemData != null) {
                this.serializeOutOfTypeSystemData(outOfTypeSystemData);
            }
            this.endElement(XCASSerializer.casTagName);
        }

        private void addText(String text) throws SAXException {
            this.ch.characters(text.toCharArray(), 0, text.length());
        }

        private String replaceInvalidXmlChars(String aString) {
            boolean controlCharFound = false;
            for (int i = 0; i < aString.length(); ++i) {
                if (this.isValidXmlChar(aString.charAt(i))) continue;
                controlCharFound = true;
                break;
            }
            if (!controlCharFound) {
                return aString;
            }
            char[] chars = aString.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (this.isValidXmlChar(chars[i])) continue;
                chars[i] = 65533;
            }
            return new String(chars);
        }

        private boolean isValidXmlChar(char c) {
            return c >= ' ' && c < '\ufffe' || c == '\t' || c == '\n' || c == '\r';
        }

        private void addAttribute(AttributesImpl attrs, String attrName, String attrValue) {
            if ("sofaString".equals(attrName)) {
                attrValue = this.replaceInvalidXmlChars(attrValue);
            }
            attrs.addAttribute("", attrName, attrName, cdataType, attrValue);
        }

        private void startElement(String tag, Attributes attrs, int num) throws SAXException {
            XCASSerializer.this.numChildren = num;
            this.ch.startElement("", tag, tag, attrs);
        }

        private void endElement(String tag) throws SAXException {
            this.ch.endElement("", "", tag);
        }

        private void encodeIndexed() throws IOException, SAXException {
            int max = this.indexedFSs.size();
            for (int i = 0; i < max; ++i) {
                if (-2 != this.queued.get(this.indexedFSs.get(i))) {
                    IntVector iv = new IntVector(1);
                    iv.add(this.indexReps.get(i));
                    this.encodeFS(this.indexedFSs.get(i), iv);
                    continue;
                }
                int thisDup = this.duplicates.get(this.indexedFSs.get(i));
                this.encodeFS(this.indexedFSs.get(i), this.dupVectors.get(thisDup));
            }
        }

        private void enqueueIndexed() {
            Collection<Sofa> sofaCollection = this.cas.getBaseIndexRepositoryImpl().getIndexedFSs(Sofa.class);
            int sofaCount = sofaCollection.size();
            if (sofaCount > 0) {
                TOP[] allSofas = sofaCollection.toArray(new Sofa[sofaCount]);
                Arrays.sort(allSofas, (fs1, fs2) -> Integer.compare(fs1._id, fs2._id));
                this.enqueueArray(allSofas, 0);
            }
            int numViews = this.cas.getViewCount();
            for (int sofaNum = 1; sofaNum <= numViews; ++sofaNum) {
                Collection<TOP> fssInView;
                FSIndexRepositoryImpl viewIR = this.cas.getBaseCAS().getSofaIndexRepository(sofaNum);
                if (viewIR == null || (fssInView = viewIR.getIndexedFSs()).isEmpty()) continue;
                this.enqueueCollection(fssInView, sofaNum);
            }
        }

        private void enqueueArray(TOP[] fss, int sofaNum) {
            for (TOP fs : fss) {
                this.enqueueIndexed(fs, sofaNum);
            }
        }

        private void enqueueCollection(Collection<TOP> fss, int sofaNum) {
            for (TOP fs : fss) {
                this.enqueueIndexed(fs, sofaNum);
            }
        }

        private void enqueueFeaturesOfIndexed() {
            int max = this.indexedFSs.size();
            for (int i = 0; i < max; ++i) {
                TOP fs = this.indexedFSs.get(i);
                int typeCode = fs._getTypeCode();
                int typeClass = this.classifyType(fs._getTypeImpl());
                if (typeClass == 8) {
                    if (this.mOutOfTypeSystemData != null) {
                        this.enqueueOutOfTypeSystemFeatures(fs);
                    }
                    this.enqueueFeatures(fs, typeCode);
                    continue;
                }
                if (typeClass != 7) continue;
                this.enqueueFSArray((FSArray)fs);
            }
        }

        private void encodeQueued() throws IOException, SAXException {
            for (TOP item : this.queue) {
                this.encodeFS(item, null);
            }
        }

        private void encodeFS(TOP fs, IntVector indexRep) throws IOException, SAXException {
            ++this.fsCount;
            this.workAttrs.clear();
            if (indexRep != null) {
                if (indexRep.size() == 1) {
                    this.addAttribute(this.workAttrs, XCASSerializer.INDEXED_ATTR_NAME, Integer.toString(indexRep.get(0)));
                } else {
                    StringBuilder multIndex = new StringBuilder();
                    multIndex.append(Integer.toString(indexRep.get(0)));
                    for (int mi = 1; mi < indexRep.size(); ++mi) {
                        multIndex.append(' ').append(Integer.toString(indexRep.get(mi)));
                    }
                    this.addAttribute(this.workAttrs, XCASSerializer.INDEXED_ATTR_NAME, multIndex.toString());
                }
            }
            this.addAttribute(this.workAttrs, XCASSerializer.ID_ATTR_NAME, Integer.toString(fs._id));
            int typeClass = this.classifyType(fs._getTypeImpl());
            String[] data = null;
            String typeName = this.getTypeName(fs);
            switch (typeClass) {
                case 8: {
                    this.encodeFeatures(fs, this.workAttrs);
                    if (this.mOutOfTypeSystemData != null) {
                        this.encodeOutOfTypeSystemFeatures(fs, this.workAttrs);
                    }
                    String xcasElementName = XCASSerializer.this.getXCasElementName(typeName);
                    this.startElement(xcasElementName, this.workAttrs, 0);
                    this.endElement(xcasElementName);
                    return;
                }
                case 4: {
                    data = ((IntegerArray)fs).toStringArray();
                    break;
                }
                case 5: {
                    data = ((FloatArray)fs).toStringArray();
                    break;
                }
                case 6: {
                    data = ((StringArray)fs).toArray();
                    break;
                }
                case 7: {
                    this.encodeFSArray((FSArray)fs, this.workAttrs);
                    return;
                }
                case 14: {
                    data = ((BooleanArray)fs).toStringArray();
                    break;
                }
                case 15: {
                    data = ((ByteArray)fs).toStringArray();
                    break;
                }
                case 16: {
                    data = ((ShortArray)fs).toStringArray();
                    break;
                }
                case 17: {
                    data = ((LongArray)fs).toStringArray();
                    break;
                }
                case 18: {
                    data = ((DoubleArray)fs).toStringArray();
                    break;
                }
                default: {
                    throw new RuntimeException("Internal error: classifying FS type.");
                }
            }
            this.encodePrimitiveTypeArrayFS(data, typeName, this.workAttrs);
        }

        private void encodePrimitiveTypeArrayFS(String[] data, String typeName, AttributesImpl attrs) throws SAXException {
            this.addAttribute(attrs, XCASSerializer.ARRAY_SIZE_ATTR, Integer.toString(data.length));
            this.startElement(typeName, attrs, data.length);
            for (int i = 0; i < data.length; ++i) {
                this.startElement(XCASSerializer.ARRAY_ELEMENT_TAG, this.emptyAttrs, 1);
                this.addText(data[i] == null ? "" : data[i]);
                this.endElement(XCASSerializer.ARRAY_ELEMENT_TAG);
            }
            this.endElement(typeName);
        }

        private void encodeFSArray(FSArray fs, AttributesImpl attrs) throws SAXException {
            String typeName = fs._getTypeImpl().getName();
            int size = fs.size();
            this.addAttribute(attrs, XCASSerializer.ARRAY_SIZE_ATTR, Integer.toString(size));
            if (typeName.endsWith("[]")) {
                typeName = "uima.cas.FSArray";
            }
            this.startElement(typeName, attrs, size);
            for (int i = 0; i < size; ++i) {
                String val = null;
                Object element = fs.get(i);
                if (null == element && this.mOutOfTypeSystemData != null) {
                    List<ArrayElement> ootsElems = this.mOutOfTypeSystemData.arrayElements.get(fs);
                    if (ootsElems != null) {
                        for (ArrayElement ootsElem : ootsElems) {
                            if (ootsElem.index != i) continue;
                            val = this.mOutOfTypeSystemData.idMap.get(ootsElem.value);
                            break;
                        }
                    }
                } else if (null != element) {
                    val = Integer.toString(((TOP)element)._id);
                }
                if (val != null) {
                    this.startElement(XCASSerializer.ARRAY_ELEMENT_TAG, this.emptyAttrs, 1);
                    this.addText(val);
                } else {
                    this.startElement(XCASSerializer.ARRAY_ELEMENT_TAG, this.emptyAttrs, 0);
                }
                this.endElement(XCASSerializer.ARRAY_ELEMENT_TAG);
            }
            this.endElement(typeName);
        }

        private void enqueueFSArray(FSArray fs) {
            TOP[] theArray;
            for (TOP element : theArray = fs._getTheArray()) {
                if (element == null) continue;
                this.enqueue(element);
            }
        }

        private void encodeFeatures(TOP fs, AttributesImpl attrs) {
            TypeImpl ti = fs._getTypeImpl();
            for (FeatureImpl fi : ti.getFeatureImpls()) {
                TOP v;
                String attrValue = fi.getRangeImpl().isRefType ? (null == (v = fs.getFeatureValue(fi)) ? null : Integer.toString(v._id)) : fs.getFeatureValueAsString(fi);
                if (attrValue == null) continue;
                this.addAttribute(attrs, XCASSerializer.this.featureNames[fi.getCode()], attrValue);
            }
        }

        private void enqueueFeatures(TOP fs, int heapValue) {
            TypeImpl ti = fs._getTypeImpl();
            if (fs instanceof UimaSerializable) {
                ((UimaSerializable)((Object)fs))._save_to_cas_data();
            }
            for (FeatureImpl fi : ti.getFeatureImpls()) {
                TOP v;
                if (!fi.getRangeImpl().isRefType || null == (v = fs.getFeatureValue(fi))) continue;
                this.enqueue(v);
            }
        }

        private void encodeOutOfTypeSystemFeatures(TOP fs, AttributesImpl attrs) {
            List<Pair<String, Object>> attrList = this.mOutOfTypeSystemData.extraFeatureValues.get(fs);
            if (attrList != null) {
                for (Pair<String, Object> p : attrList) {
                    String sv;
                    String string = sv = p.u instanceof String ? (String)p.u : "";
                    if (((String)p.t).startsWith(XCASSerializer.REF_PREFIX) && sv.startsWith("a")) {
                        sv = this.mOutOfTypeSystemData.idMap.get(sv);
                        p.u = sv;
                    }
                    this.addAttribute(attrs, (String)p.t, sv);
                }
            }
        }

        private void enqueueOutOfTypeSystemFeatures(TOP fs) {
            List<Pair<String, Object>> attrList = this.mOutOfTypeSystemData.extraFeatureValues.get(fs);
            if (attrList != null) {
                for (Pair<String, Object> p : attrList) {
                    String sv;
                    String string = sv = p.u instanceof String ? (String)p.u : "";
                    if (!((String)p.t).startsWith(XCASSerializer.REF_PREFIX) || !(p.u instanceof TOP)) continue;
                    this.enqueue((TOP)p.u);
                }
            }
        }

        private final String getTypeName(TOP fs) {
            return fs.getType().getName();
        }

        private final int classifyType(TypeImpl ti) {
            return TypeSystemImpl.getTypeClass(ti);
        }

        private void enqueueOutOfTypeSystemData(OutOfTypeSystemData aData) {
            for (FSData fs : aData.fsList) {
                for (Map.Entry<String, Object> entry : fs.featVals.entrySet()) {
                    Object attrVal;
                    String attrName = entry.getKey();
                    if (!attrName.startsWith(XCASSerializer.REF_PREFIX) || !((attrVal = entry.getValue()) instanceof TOP)) continue;
                    this.enqueue((TOP)attrVal);
                }
            }
        }

        private void serializeOutOfTypeSystemData(OutOfTypeSystemData aData) throws SAXException {
            for (FSData fs : aData.fsList) {
                this.workAttrs.clear();
                if (fs.indexRep != null) {
                    this.addAttribute(this.workAttrs, XCASSerializer.INDEXED_ATTR_NAME, fs.indexRep);
                }
                this.addAttribute(this.workAttrs, XCASSerializer.ID_ATTR_NAME, fs.id);
                for (Map.Entry<String, Object> entry : fs.featVals.entrySet()) {
                    String attrName = entry.getKey();
                    Object attrVal = entry.getValue();
                    if (attrName.startsWith(XCASSerializer.REF_PREFIX) && attrVal instanceof String && ((String)attrVal).startsWith("a")) {
                        attrVal = this.mOutOfTypeSystemData.idMap.get(attrVal);
                    }
                    this.addAttribute(this.workAttrs, attrName, attrVal instanceof TOP ? Integer.toString(((TOP)attrVal)._id) : (String)attrVal);
                }
                String xcasElementName = XCASSerializer.this.getXCasElementName(fs.type);
                this.startElement(xcasElementName, this.workAttrs, 0);
                this.endElement(xcasElementName);
            }
        }
    }
}

