/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.text;

import com.github.mangstadt.vinnie.Utils;
import com.github.mangstadt.vinnie.VObjectParameters;
import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import com.github.mangstadt.vinnie.io.VObjectWriter;
import ezvcard.VCard;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.EmbeddedVCardException;
import ezvcard.io.SkipMeException;
import ezvcard.io.StreamWriter;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.text.TargetApplication;
import ezvcard.io.text.WriteContext;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.Address;
import ezvcard.property.BinaryProperty;
import ezvcard.property.VCardProperty;
import ezvcard.util.IOUtils;
import ezvcard.util.Utf8Writer;
import java.io.File;
import java.io.FileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCardWriter
extends StreamWriter
implements Flushable {
    private final VObjectWriter writer;
    private final List<Boolean> prodIdStack = new ArrayList<Boolean>();
    private VCardVersion targetVersion;
    private TargetApplication targetApplication;
    private Boolean includeTrailingSemicolons;

    public VCardWriter(OutputStream out, VCardVersion targetVersion) {
        this(targetVersion == VCardVersion.V4_0 ? new Utf8Writer(out) : new OutputStreamWriter(out), targetVersion);
    }

    public VCardWriter(File file, VCardVersion targetVersion) throws IOException {
        this(file, false, targetVersion);
    }

    public VCardWriter(File file, boolean append, VCardVersion targetVersion) throws IOException {
        this(targetVersion == VCardVersion.V4_0 ? new Utf8Writer(file, append) : new FileWriter(file, append), targetVersion);
    }

    public VCardWriter(Writer writer, VCardVersion targetVersion) {
        this.writer = new VObjectWriter(writer, targetVersion.getSyntaxStyle());
        this.targetVersion = targetVersion;
    }

    public VObjectWriter getVObjectWriter() {
        return this.writer;
    }

    @Override
    public VCardVersion getTargetVersion() {
        return this.targetVersion;
    }

    public void setTargetVersion(VCardVersion targetVersion) {
        this.writer.setSyntaxStyle(targetVersion.getSyntaxStyle());
        this.targetVersion = targetVersion;
    }

    public TargetApplication getTargetApplication() {
        return this.targetApplication;
    }

    public void setTargetApplication(TargetApplication targetApplication) {
        this.targetApplication = targetApplication;
    }

    public Boolean isIncludeTrailingSemicolons() {
        return this.includeTrailingSemicolons;
    }

    public void setIncludeTrailingSemicolons(Boolean include) {
        this.includeTrailingSemicolons = include;
    }

    public boolean isCaretEncodingEnabled() {
        return this.writer.isCaretEncodingEnabled();
    }

    public void setCaretEncodingEnabled(boolean enable) {
        this.writer.setCaretEncodingEnabled(enable);
    }

    @Override
    protected void _write(VCard vcard, List<VCardProperty> propertiesToAdd) throws IOException {
        VCardVersion targetVersion = this.getTargetVersion();
        TargetApplication targetApplication = this.getTargetApplication();
        Boolean includeTrailingSemicolons = this.includeTrailingSemicolons;
        if (includeTrailingSemicolons == null) {
            includeTrailingSemicolons = targetVersion == VCardVersion.V4_0;
        }
        WriteContext context = new WriteContext(targetVersion, targetApplication, includeTrailingSemicolons);
        this.writer.writeBeginComponent("VCARD");
        this.writer.writeVersion(targetVersion.getVersion());
        for (VCardProperty property : propertiesToAdd) {
            VCardPropertyScribe<? extends VCardProperty> scribe = this.index.getPropertyScribe(property);
            String value = null;
            VCard nestedVCard = null;
            try {
                value = scribe.writeText(property, context);
            }
            catch (SkipMeException e) {
                continue;
            }
            catch (EmbeddedVCardException e) {
                nestedVCard = e.getVCard();
            }
            VCardParameters parameters = scribe.prepareParameters(property, targetVersion, vcard);
            if (nestedVCard != null) {
                this.writeNestedVCard(nestedVCard, property, scribe, parameters, value);
                continue;
            }
            this.handleValueParameter(property, scribe, parameters);
            this.handleLabelParameter(property, parameters);
            this.writer.writeProperty(property.getGroup(), scribe.getPropertyName(), new VObjectParameters(parameters.getMap()), value);
            this.fixBinaryPropertyForOutlook(property);
        }
        this.writer.writeEndComponent("VCARD");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNestedVCard(VCard nestedVCard, VCardProperty property, VCardPropertyScribe scribe, VCardParameters parameters, String value) throws IOException {
        if (this.targetVersion == VCardVersion.V2_1) {
            this.writer.writeProperty(property.getGroup(), scribe.getPropertyName(), new VObjectParameters(parameters.getMap()), value);
            this.prodIdStack.add(this.addProdId);
            this.addProdId = false;
            this.write(nestedVCard);
            this.addProdId = this.prodIdStack.remove(this.prodIdStack.size() - 1);
        } else {
            StringWriter sw = new StringWriter();
            VCardWriter agentWriter = new VCardWriter(sw, this.targetVersion);
            agentWriter.getVObjectWriter().getFoldedLineWriter().setLineLength(null);
            agentWriter.setAddProdId(false);
            agentWriter.setCaretEncodingEnabled(this.isCaretEncodingEnabled());
            agentWriter.setIncludeTrailingSemicolons(this.includeTrailingSemicolons);
            agentWriter.setScribeIndex(this.index);
            agentWriter.setTargetApplication(this.targetApplication);
            agentWriter.setVersionStrict(this.versionStrict);
            try {
                agentWriter.write(nestedVCard);
            }
            catch (IOException iOException) {
            }
            finally {
                IOUtils.closeQuietly(agentWriter);
            }
            String vcardStr = sw.toString();
            vcardStr = VObjectPropertyValues.escape((String)vcardStr);
            this.writer.writeProperty(property.getGroup(), scribe.getPropertyName(), new VObjectParameters(parameters.getMap()), vcardStr);
        }
    }

    private void handleValueParameter(VCardProperty property, VCardPropertyScribe scribe, VCardParameters parameters) {
        VCardDataType dataType = scribe.dataType(property, this.targetVersion);
        if (dataType == null) {
            return;
        }
        VCardDataType defaultDataType = scribe.defaultDataType(this.targetVersion);
        if (dataType == defaultDataType) {
            return;
        }
        if (this.isDateTimeValueParameterSpecialCase(defaultDataType, dataType)) {
            return;
        }
        parameters.setValue(dataType);
    }

    private void handleLabelParameter(VCardProperty property, VCardParameters parameters) {
        if (!(property instanceof Address)) {
            return;
        }
        String label = parameters.getLabel();
        if (label == null) {
            return;
        }
        label = Utils.escapeNewlines((String)label);
        parameters.setLabel(label);
    }

    private void fixBinaryPropertyForOutlook(VCardProperty property) throws IOException {
        if (this.targetApplication != TargetApplication.OUTLOOK) {
            return;
        }
        if (this.getTargetVersion() == VCardVersion.V4_0) {
            return;
        }
        if (!(property instanceof BinaryProperty)) {
            return;
        }
        BinaryProperty binaryProperty = (BinaryProperty)property;
        if (binaryProperty.getData() == null) {
            return;
        }
        this.writer.getFoldedLineWriter().writeln();
    }

    private boolean isDateTimeValueParameterSpecialCase(VCardDataType defaultDataType, VCardDataType dataType) {
        return defaultDataType == VCardDataType.DATE_AND_OR_TIME && (dataType == VCardDataType.DATE || dataType == VCardDataType.DATE_TIME || dataType == VCardDataType.TIME);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

