/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.CannotParseException;
import ezvcard.io.ParseContext;
import ezvcard.io.html.HCardElement;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.text.WriteContext;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.Revision;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevisionScribe
extends VCardPropertyScribe<Revision> {
    public RevisionScribe() {
        super(Revision.class, "REV");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return VCardDataType.TIMESTAMP;
    }

    @Override
    protected String _writeText(Revision property, WriteContext context) {
        boolean extended = context.getVersion() == VCardVersion.V3_0;
        return this.write(property, extended);
    }

    @Override
    protected Revision _parseText(String value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        return this.parse(value);
    }

    @Override
    protected void _writeXml(Revision property, XCardElement parent) {
        parent.append(VCardDataType.TIMESTAMP, this.write(property, false));
    }

    @Override
    protected Revision _parseXml(XCardElement element, VCardParameters parameters, ParseContext context) {
        String value = element.first(VCardDataType.TIMESTAMP);
        if (value != null) {
            return this.parse(value);
        }
        throw RevisionScribe.missingXmlElements(VCardDataType.TIMESTAMP);
    }

    @Override
    protected Revision _parseHtml(HCardElement element, ParseContext context) {
        String datetime;
        String value = null;
        if ("time".equals(element.tagName()) && (datetime = element.attr("datetime")).length() > 0) {
            value = datetime;
        }
        if (value == null) {
            value = element.value();
        }
        return this.parse(value);
    }

    @Override
    protected JCardValue _writeJson(Revision property) {
        return JCardValue.single(this.write(property, true));
    }

    @Override
    protected Revision _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        String valueStr = value.asSingle();
        return this.parse(valueStr);
    }

    private String write(Revision property, boolean extended) {
        Date timestamp = (Date)property.getValue();
        if (timestamp == null) {
            return "";
        }
        return RevisionScribe.date(timestamp).time(true).utc(true).extended(extended).write();
    }

    private Revision parse(String value) {
        if (value == null || value.length() == 0) {
            return new Revision((Date)null);
        }
        try {
            return new Revision(RevisionScribe.date(value));
        }
        catch (IllegalArgumentException e) {
            throw new CannotParseException(5, new Object[0]);
        }
    }
}

