/*
 * Decompiled with CFR 0.152.
 */
package org.fishwife.jrugged;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import org.fishwife.jrugged.CircuitBreakerException;
import org.fishwife.jrugged.CircuitBreakerExceptionMapper;
import org.fishwife.jrugged.CircuitBreakerNotificationCallback;
import org.fishwife.jrugged.DefaultFailureInterpreter;
import org.fishwife.jrugged.FailureInterpreter;
import org.fishwife.jrugged.MonitoredService;
import org.fishwife.jrugged.ServiceStatus;
import org.fishwife.jrugged.ServiceWrapper;
import org.fishwife.jrugged.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircuitBreaker
implements MonitoredService,
ServiceWrapper {
    private Throwable tripException = null;
    protected volatile BreakerState state = BreakerState.CLOSED;
    protected AtomicLong lastFailure = new AtomicLong(0L);
    protected AtomicLong openCount = new AtomicLong(0L);
    protected AtomicLong resetMillis = new AtomicLong(15000L);
    protected FailureInterpreter failureInterpreter = new DefaultFailureInterpreter();
    protected CircuitBreakerExceptionMapper<? extends Exception> exceptionMapper;
    protected List<CircuitBreakerNotificationCallback> cbNotifyList = Collections.synchronizedList(new ArrayList());
    private boolean isHardTrip;
    protected boolean byPass = false;
    protected boolean isAttemptLive = false;
    private static final String DEFAULT_NAME = "CircuitBreaker";
    private String name = "CircuitBreaker";

    public Throwable getTripException() {
        return this.tripException;
    }

    public String getTripExceptionAsString() {
        if (this.tripException == null) {
            return "";
        }
        return this.getFullStackTrace(this.tripException);
    }

    public CircuitBreaker() {
    }

    public CircuitBreaker(String name) {
        this.name = name;
    }

    public CircuitBreaker(FailureInterpreter fi) {
        this.failureInterpreter = fi;
    }

    public CircuitBreaker(String name, FailureInterpreter fi) {
        this.name = name;
        this.failureInterpreter = fi;
    }

    public CircuitBreaker(String name, CircuitBreakerExceptionMapper<? extends Exception> mapper) {
        this.name = name;
        this.exceptionMapper = mapper;
    }

    public CircuitBreaker(String name, FailureInterpreter fi, CircuitBreakerExceptionMapper<? extends Exception> mapper) {
        this.name = name;
        this.failureInterpreter = fi;
        this.exceptionMapper = mapper;
    }

    public <V> V invoke(Callable<V> c) throws Exception {
        if (!this.byPass) {
            if (!this.allowRequest()) {
                throw this.mapException(new CircuitBreakerException());
            }
            try {
                V result = c.call();
                this.close();
                return result;
            }
            catch (Throwable cause) {
                this.handleFailure(cause);
                throw new IllegalStateException("not possible");
            }
        }
        return c.call();
    }

    @Override
    public void invoke(Runnable r) throws Exception {
        if (!this.byPass) {
            if (!this.allowRequest()) {
                throw this.mapException(new CircuitBreakerException());
            }
            try {
                r.run();
                this.close();
                return;
            }
            catch (Throwable cause) {
                this.handleFailure(cause);
                throw new IllegalStateException("not possible");
            }
        }
        r.run();
    }

    public <V> V invoke(Runnable r, V result) throws Exception {
        if (!this.byPass) {
            if (!this.allowRequest()) {
                throw this.mapException(new CircuitBreakerException());
            }
            try {
                r.run();
                this.close();
                return result;
            }
            catch (Throwable cause) {
                this.handleFailure(cause);
                throw new IllegalStateException("not possible");
            }
        }
        r.run();
        return result;
    }

    public void setByPassState(boolean b) {
        this.byPass = b;
        this.notifyBreakerStateChange(this.getStatus());
    }

    public boolean getByPassState() {
        return this.byPass;
    }

    public void trip() {
        if (this.state != BreakerState.OPEN) {
            this.openCount.getAndIncrement();
        }
        this.state = BreakerState.OPEN;
        this.lastFailure.set(System.currentTimeMillis());
        this.isAttemptLive = false;
        this.notifyBreakerStateChange(this.getStatus());
    }

    public void tripHard() {
        this.trip();
        this.isHardTrip = true;
    }

    public long getLastTripTime() {
        return this.lastFailure.get();
    }

    public long getTripCount() {
        return this.openCount.get();
    }

    public void reset() {
        this.state = BreakerState.CLOSED;
        this.isHardTrip = false;
        this.byPass = false;
        this.isAttemptLive = false;
        this.notifyBreakerStateChange(this.getStatus());
    }

    public Status getStatus() {
        return this.getServiceStatus().getStatus();
    }

    @Override
    public ServiceStatus getServiceStatus() {
        boolean canSendProbeRequest;
        boolean bl = canSendProbeRequest = !this.isHardTrip && this.lastFailure.get() > 0L && this.allowRequest();
        if (this.byPass) {
            return new ServiceStatus(this.name, Status.DEGRADED, "Bypassed");
        }
        switch (this.state) {
            case OPEN: {
                return canSendProbeRequest ? new ServiceStatus(this.name, Status.DEGRADED, "Send Probe Request") : new ServiceStatus(this.name, Status.DOWN, "Open");
            }
            case HALF_CLOSED: {
                return new ServiceStatus(this.name, Status.DEGRADED, "Half Closed");
            }
        }
        return new ServiceStatus(this.name, Status.UP);
    }

    public long getResetMillis() {
        return this.resetMillis.get();
    }

    public void setResetMillis(long l) {
        this.resetMillis.set(l);
    }

    public String getHealthCheck() {
        return this.getStatus().getSignal();
    }

    public void setLimit(int limit) {
        FailureInterpreter fi = this.getFailureInterpreter();
        if (!(fi instanceof DefaultFailureInterpreter)) {
            throw new IllegalStateException("setLimit() not supported: this CircuitBreaker's FailureInterpreter isn't a DefaultFailureInterpreter.");
        }
        ((DefaultFailureInterpreter)fi).setLimit(limit);
    }

    public void setIgnore(Collection<Class<? extends Throwable>> ignore) {
        FailureInterpreter fi = this.getFailureInterpreter();
        if (!(fi instanceof DefaultFailureInterpreter)) {
            throw new IllegalStateException("setIgnore() not supported: this CircuitBreaker's FailureInterpreter isn't a DefaultFailureInterpreter.");
        }
        Class[] classes = new Class[ignore.size()];
        int i = 0;
        Iterator<Class<? extends Throwable>> i$ = ignore.iterator();
        while (i$.hasNext()) {
            Class<? extends Throwable> c;
            classes[i] = c = i$.next();
            ++i;
        }
        ((DefaultFailureInterpreter)fi).setIgnore(classes);
    }

    public void setWindowMillis(long windowMillis) {
        FailureInterpreter fi = this.getFailureInterpreter();
        if (!(fi instanceof DefaultFailureInterpreter)) {
            throw new IllegalStateException("setWindowMillis() not supported: this CircuitBreaker's FailureInterpreter isn't a DefaultFailureInterpreter.");
        }
        ((DefaultFailureInterpreter)fi).setWindowMillis(windowMillis);
    }

    public void setFailureInterpreter(FailureInterpreter failureInterpreter) {
        this.failureInterpreter = failureInterpreter;
    }

    public FailureInterpreter getFailureInterpreter() {
        return this.failureInterpreter;
    }

    public void setExceptionMapper(CircuitBreakerExceptionMapper<? extends Exception> mapper) {
        this.exceptionMapper = mapper;
    }

    public void addListener(CircuitBreakerNotificationCallback listener) {
        this.cbNotifyList.add(listener);
    }

    public void setListeners(ArrayList<CircuitBreakerNotificationCallback> listeners) {
        this.cbNotifyList = Collections.synchronizedList(listeners);
    }

    public CircuitBreakerExceptionMapper<? extends Exception> getExceptionMapper() {
        return this.exceptionMapper;
    }

    private Exception mapException(CircuitBreakerException cbe) {
        if (this.exceptionMapper == null) {
            return cbe;
        }
        return this.exceptionMapper.map(this, cbe);
    }

    private void handleFailure(Throwable cause) throws Exception {
        if (this.failureInterpreter == null || this.failureInterpreter.shouldTrip(cause)) {
            this.tripException = cause;
            this.trip();
        } else if (this.isAttemptLive) {
            this.close();
        }
        if (cause instanceof Exception) {
            throw (Exception)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw (RuntimeException)cause;
    }

    private void close() {
        this.state = BreakerState.CLOSED;
        this.isAttemptLive = false;
        this.notifyBreakerStateChange(this.getStatus());
    }

    private synchronized boolean canAttempt() {
        if (BreakerState.HALF_CLOSED != this.state || this.isAttemptLive) {
            return false;
        }
        this.isAttemptLive = true;
        return true;
    }

    private void notifyBreakerStateChange(Status status) {
        if (this.cbNotifyList != null && this.cbNotifyList.size() >= 1) {
            for (CircuitBreakerNotificationCallback notifyObject : this.cbNotifyList) {
                notifyObject.notify(status);
            }
        }
    }

    private boolean allowRequest() {
        if (this.isHardTrip) {
            return false;
        }
        if (BreakerState.CLOSED == this.state) {
            return true;
        }
        if (BreakerState.OPEN == this.state && System.currentTimeMillis() - this.lastFailure.get() >= this.resetMillis.get()) {
            this.state = BreakerState.HALF_CLOSED;
        }
        return this.canAttempt();
    }

    private String getFullStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum BreakerState {
        OPEN,
        HALF_CLOSED,
        CLOSED;

    }
}

