/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.nlp.tokenizer;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.ctakes.core.nlp.tokenizer.TokenizerHelper;

public class HyphenatedPTB {
    static String[] MultiTokenWords = new String[]{"cannot", "gonna", "gotta", "lemme", "wanna", "whaddya", "whatcha"};
    static int[] MultiTokenWordLenToken1 = new int[]{3, 3, 3, 3, 3, 3, 3};
    static int[] MultiTokenWordLenToken2 = new int[]{3, 2, 2, 2, 2, 2, 1};
    static HashMap<String, Integer> MultiTokenWordsLookup = new HashMap();
    static String[] possibleContractionEndings;
    static String lettersAfterApostropheForMiddleOfContraction;
    static String[] contractionsStartingWithApostrophe;
    static String[] hyphenatedPrefixes;
    static HashSet<String> hyphenatedPrefixesLookup;
    static String[] hyphenatedSuffixes;
    static HashSet<String> hyphenatedSuffixesLookup;
    static String[] hyphenatedWords;
    static HashSet<String> hyphenatedWordsLookup;
    static char MINUS_OR_HYPHEN;

    static int lenOfFirstTokenInContraction(String s) {
        Integer integer = MultiTokenWordsLookup.get(s);
        if (integer == null) {
            return -1;
        }
        return MultiTokenWordLenToken1[integer];
    }

    static boolean isContractionThatStartsWithApostrophe(int currentPosition, String textSegment) {
        String text = textSegment.substring(currentPosition);
        for (String s : contractionsStartingWithApostrophe) {
            if (!TokenizerHelper.startsWithWithoutBeingFollowedByLetter(text, s)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        for (int i = 0; i < MultiTokenWords.length; ++i) {
            String s = MultiTokenWords[i];
            String SPACE = " ";
            System.out.println(s.substring(0, MultiTokenWordLenToken1[i]) + SPACE + s.substring(MultiTokenWordLenToken1[i], MultiTokenWordLenToken1[i] + MultiTokenWordLenToken2[i]) + SPACE + s.substring(MultiTokenWordLenToken1[i] + MultiTokenWordLenToken2[i]));
        }
    }

    public static int tokenLengthCheckingForHyphenatedTerms(String lowerCasedString) {
        if (lowerCasedString == null) {
            throw new UnsupportedOperationException("no hyphen found in (null)");
        }
        int firstBreak = lowerCasedString.indexOf(MINUS_OR_HYPHEN);
        if (firstBreak < 0) {
            throw new UnsupportedOperationException("no hyphen found in '" + lowerCasedString + "'");
        }
        if (firstBreak == 0) {
            return -1;
        }
        if (firstBreak + 1 == lowerCasedString.length()) {
            return firstBreak;
        }
        int secondBreak = TokenizerHelper.findNextNonAlphaNum(lowerCasedString, firstBreak + 1);
        int thirdBreak = -1;
        if (secondBreak != lowerCasedString.length()) {
            thirdBreak = TokenizerHelper.findNextNonAlphaNum(lowerCasedString, secondBreak + 1);
        }
        if (secondBreak == lowerCasedString.length()) {
            return HyphenatedPTB.lenIncludingHyphensToKeep(lowerCasedString, firstBreak, 1, secondBreak, thirdBreak);
        }
        if (lowerCasedString.charAt(secondBreak) == MINUS_OR_HYPHEN) {
            return HyphenatedPTB.lenIncludingHyphensToKeep(lowerCasedString, firstBreak, 2, secondBreak, thirdBreak);
        }
        if (lowerCasedString.charAt(secondBreak) == '\'') {
            return HyphenatedPTB.lenIncludingHyphensToKeep(lowerCasedString, firstBreak, 1, secondBreak, thirdBreak);
        }
        if (Character.isWhitespace(lowerCasedString.charAt(secondBreak))) {
            return HyphenatedPTB.lenIncludingHyphensToKeep(lowerCasedString, firstBreak, 1, secondBreak, thirdBreak);
        }
        return HyphenatedPTB.lenIncludingHyphensToKeep(lowerCasedString, firstBreak, 1, secondBreak, thirdBreak);
    }

    private static int lenIncludingHyphensToKeep(String s, int indexOfFirstHyphen, int numberOfHyphensToConsiderKeeping, int secondBreak, int thirdBreak) {
        String possibleHyphenatedWordsLookupMatch;
        boolean lookup2;
        String possiblePrefix;
        String possibleSuffix;
        boolean lookup;
        if (numberOfHyphensToConsiderKeeping > 2 || numberOfHyphensToConsiderKeeping < 1) {
            throw new UnsupportedOperationException("Not ready to handle numberOfHyphensToConsiderKeeping = " + numberOfHyphensToConsiderKeeping);
        }
        if (numberOfHyphensToConsiderKeeping == 2 && (lookup = hyphenatedSuffixesLookup.contains(possibleSuffix = s.substring(indexOfFirstHyphen, thirdBreak)))) {
            return thirdBreak;
        }
        possibleSuffix = s.substring(indexOfFirstHyphen, secondBreak);
        lookup = hyphenatedSuffixesLookup.contains(possibleSuffix);
        if (lookup) {
            if (thirdBreak > secondBreak && (lookup = hyphenatedSuffixesLookup.contains(possibleSuffix = s.substring(secondBreak, thirdBreak)))) {
                return thirdBreak;
            }
            return secondBreak;
        }
        if (numberOfHyphensToConsiderKeeping > 1) {
            String possibleHyphenatedWordsLookupMatch2 = s.substring(0, secondBreak);
            possibleSuffix = s.substring(secondBreak, thirdBreak);
            boolean bl = lookup = hyphenatedWordsLookup.contains(possibleHyphenatedWordsLookupMatch2) && hyphenatedSuffixesLookup.contains(possibleSuffix);
            if (lookup) {
                return thirdBreak;
            }
        }
        if ((lookup = hyphenatedPrefixesLookup.contains(possiblePrefix = s.substring(0, indexOfFirstHyphen + 1))) && numberOfHyphensToConsiderKeeping > 1 && (lookup2 = hyphenatedWordsLookup.contains(possibleHyphenatedWordsLookupMatch = s.substring(indexOfFirstHyphen + 1, thirdBreak)))) {
            return thirdBreak;
        }
        if (numberOfHyphensToConsiderKeeping == 1 && lookup) {
            return secondBreak;
        }
        if (numberOfHyphensToConsiderKeeping == 2 && lookup) {
            possibleSuffix = s.substring(secondBreak, thirdBreak);
            boolean lookup22 = hyphenatedSuffixesLookup.contains(possibleSuffix);
            if (lookup22) {
                return thirdBreak;
            }
            return secondBreak;
        }
        possibleHyphenatedWordsLookupMatch = s.substring(0, secondBreak);
        lookup = hyphenatedWordsLookup.contains(possibleHyphenatedWordsLookupMatch);
        if (lookup) {
            return secondBreak;
        }
        return indexOfFirstHyphen;
    }

    static int lenIfHyphenatedSuffix(String lowerCasedString, int position) {
        boolean lookup;
        lowerCasedString = lowerCasedString.toLowerCase();
        int next = TokenizerHelper.findNextNonAlphaNum(lowerCasedString, position + 1);
        String possibleSuffix = lowerCasedString.substring(position, next);
        if (lowerCasedString.substring(position).startsWith("-o-")) {
            next = TokenizerHelper.findNextNonAlphaNum(lowerCasedString, position + 3);
            possibleSuffix = lowerCasedString.substring(position, next);
        }
        if (lookup = hyphenatedSuffixesLookup.contains(possibleSuffix)) {
            return possibleSuffix.length();
        }
        return -1;
    }

    static {
        for (int i = 0; i < MultiTokenWords.length; ++i) {
            MultiTokenWordsLookup.put(MultiTokenWords[i], i);
        }
        possibleContractionEndings = new String[]{"'s", "'ve", "'re", "'ll", "'d", "'n", "n't"};
        lettersAfterApostropheForMiddleOfContraction = "";
        for (String s : possibleContractionEndings) {
            lettersAfterApostropheForMiddleOfContraction = lettersAfterApostropheForMiddleOfContraction + s.charAt(1);
        }
        contractionsStartingWithApostrophe = new String[]{"'tis", "'twas"};
        hyphenatedPrefixes = new String[]{"e-", "a-", "u-", "x-", "agro-", "ante-", "anti-", "arch-", "be-", "bi-", "bio-", "co-", "counter-", "cross-", "cyber-", "de-", "eco-", "ex-", "extra-", "inter-", "intra-", "macro-", "mega-", "micro-", "mid-", "mini-", "multi-", "neo-", "non-", "over-", "pan-", "para-", "peri-", "post-", "pre-", "pro-", "pseudo-", "quasi-", "re-", "semi-", "sub-", "super-", "tri-", "ultra-", "un-", "uni-", "vice-", "electro-", "gasto-", "homo-", "hetero-", "ortho-", "phospho-"};
        hyphenatedPrefixesLookup = new HashSet();
        for (String s : hyphenatedPrefixes) {
            hyphenatedPrefixesLookup.add(s);
        }
        hyphenatedSuffixes = new String[]{"-esque", "-ette", "-fest", "-fold", "-gate", "-itis", "-less", "-most", "-o-torium", "-rama", "-wise"};
        hyphenatedSuffixesLookup = new HashSet();
        for (String s : hyphenatedSuffixes) {
            hyphenatedSuffixesLookup.add(s);
        }
        hyphenatedWords = new String[]{"mm-hm", "mm-mm", "o-kay", "uh-huh", "uh-oh"};
        hyphenatedWordsLookup = new HashSet();
        for (String s : hyphenatedWords) {
            hyphenatedWordsLookup.add(s);
        }
        MINUS_OR_HYPHEN = (char)45;
    }
}

