/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.adapter;

import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.adapter.SimpleCompletedFuture;
import com.hazelcast.monitor.LocalMapStats;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ReplicatedMapDataStructureAdapter<K, V>
implements DataStructureAdapter<K, V> {
    private final ReplicatedMap<K, V> map;

    public ReplicatedMapDataStructureAdapter(ReplicatedMap<K, V> map) {
        this.map = map;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public void set(K key, V value) {
        this.map.put(key, value);
    }

    @Override
    public V put(K key, V value) {
        return this.map.put(key, value);
    }

    @Override
    public V get(K key) {
        return this.map.get(key);
    }

    @Override
    public ICompletableFuture<V> getAsync(K key) {
        return new SimpleCompletedFuture(this.map.get(key));
    }

    @Override
    public void putAll(Map<K, V> map) {
        this.map.putAll(map);
    }

    @Override
    public Map<K, V> getAll(Set<K> keys) {
        HashMap result = new HashMap(keys.size());
        for (K key : keys) {
            result.put(key, this.map.get(key));
        }
        return result;
    }

    @Override
    public void remove(K key) {
        this.map.remove(key);
    }

    @Override
    public LocalMapStats getLocalMapStats() {
        return null;
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }
}

