/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.local;

import com.hazelcast.hibernate.local.LocalRegionCache;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class CleanupService {
    private static final long FIXED_DELAY = 60L;
    private static final long FIXED_DELAY1 = 60L;
    private final String name;
    private final ScheduledExecutorService executor;

    public CleanupService(String name) {
        this.name = name;
        this.executor = Executors.newSingleThreadScheduledExecutor(new CleanupThreadFactory());
    }

    public void registerCache(final LocalRegionCache cache) {
        this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                cache.cleanup();
            }
        }, 60L, 60L, TimeUnit.SECONDS);
    }

    public void stop() {
        this.executor.shutdownNow();
    }

    private static final class CleanupThread
    extends Thread {
        private CleanupThread(Runnable target, String name) {
            super(target, name);
        }

        @Override
        public void run() {
            try {
                super.run();
            }
            catch (OutOfMemoryError e) {
                OutOfMemoryErrorDispatcher.onOutOfMemory(e);
            }
        }
    }

    private class CleanupThreadFactory
    implements ThreadFactory {
        private CleanupThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            CleanupThread thread = new CleanupThread(r, CleanupService.this.name + ".hibernate.cleanup");
            thread.setDaemon(true);
            return thread;
        }
    }
}

