/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.PartitionListener;
import com.hazelcast.internal.partition.impl.PartitionReplicaChangeEvent;
import com.hazelcast.nio.Address;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;

public class InternalPartitionImpl
implements InternalPartition {
    @SuppressFBWarnings(value={"VO_VOLATILE_REFERENCE_TO_ARRAY"}, justification="The contents of this array will never be updated, so it can be safely read using a volatile read. Writing to `addresses` is done under InternalPartitionServiceImpl.lock, so there's no need to guard `addresses` field or to use a CAS.")
    private volatile Address[] addresses = new Address[7];
    private final int partitionId;
    private final PartitionListener partitionListener;
    private final Address thisAddress;
    private volatile boolean isMigrating;

    InternalPartitionImpl(int partitionId, PartitionListener partitionListener, Address thisAddress) {
        this.partitionId = partitionId;
        this.partitionListener = partitionListener;
        this.thisAddress = thisAddress;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public InternalPartitionImpl(int partitionId, PartitionListener listener, Address thisAddress, Address[] addresses) {
        this(partitionId, listener, thisAddress);
        this.addresses = addresses;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public boolean isMigrating() {
        return this.isMigrating;
    }

    public void setMigrating(boolean isMigrating) {
        this.isMigrating = isMigrating;
    }

    @Override
    public boolean isLocal() {
        return this.thisAddress.equals(this.getOwnerOrNull());
    }

    @Override
    public Address getOwnerOrNull() {
        return this.addresses[0];
    }

    @Override
    public Address getReplicaAddress(int replicaIndex) {
        return this.addresses[replicaIndex];
    }

    void swapAddresses(int index1, int index2) {
        Address a2;
        Address[] newAddresses = Arrays.copyOf(this.addresses, 7);
        Address a1 = newAddresses[index1];
        newAddresses[index1] = a2 = newAddresses[index2];
        newAddresses[index2] = a1;
        this.addresses = newAddresses;
        this.callPartitionListener(index1, a1, a2);
        this.callPartitionListener(index2, a2, a1);
    }

    void setInitialReplicaAddresses(Address[] newAddresses) {
        Address[] oldAddresses = this.addresses;
        for (int replicaIndex = 0; replicaIndex < 7; ++replicaIndex) {
            if (oldAddresses[replicaIndex] == null) continue;
            throw new IllegalStateException("Partition is already initialized!");
        }
        this.addresses = newAddresses;
    }

    void setReplicaAddresses(Address[] newAddresses) {
        Address[] oldAddresses = this.addresses;
        this.addresses = newAddresses;
        this.callPartitionListener(newAddresses, oldAddresses);
    }

    void setReplicaAddress(int replicaIndex, Address newAddress) {
        Address[] newAddresses = Arrays.copyOf(this.addresses, 7);
        Address oldAddress = newAddresses[replicaIndex];
        newAddresses[replicaIndex] = newAddress;
        this.addresses = newAddresses;
        this.callPartitionListener(replicaIndex, oldAddress, newAddress);
    }

    private void callPartitionListener(Address[] newAddresses, Address[] oldAddresses) {
        if (this.partitionListener != null) {
            for (int replicaIndex = 0; replicaIndex < 7; ++replicaIndex) {
                Address oldAddress = oldAddresses[replicaIndex];
                Address newAddress = newAddresses[replicaIndex];
                this.callPartitionListener(replicaIndex, oldAddress, newAddress);
            }
        }
    }

    private void callPartitionListener(int replicaIndex, Address oldAddress, Address newAddress) {
        boolean changed;
        if (oldAddress == null) {
            changed = newAddress != null;
        } else {
            boolean bl = changed = !oldAddress.equals(newAddress);
        }
        if (changed) {
            PartitionReplicaChangeEvent event = new PartitionReplicaChangeEvent(this.partitionId, replicaIndex, oldAddress, newAddress);
            this.partitionListener.replicaChanged(event);
        }
    }

    InternalPartitionImpl copy(PartitionListener listener) {
        return new InternalPartitionImpl(this.partitionId, listener, this.thisAddress, Arrays.copyOf(this.addresses, 7));
    }

    Address[] getReplicaAddresses() {
        return this.addresses;
    }

    @Override
    public boolean isOwnerOrBackup(Address address) {
        return this.getReplicaIndex(address) >= 0;
    }

    @Override
    public int getReplicaIndex(Address address) {
        return InternalPartitionImpl.getReplicaIndex(this.addresses, address);
    }

    public static int getReplicaIndex(Address[] addresses, Address address) {
        if (address == null) {
            return -1;
        }
        for (int i = 0; i < 7; ++i) {
            if (!address.equals(addresses[i])) continue;
            return i;
        }
        return -1;
    }

    int replaceAddress(Address oldAddress, Address newAddress) {
        Address address;
        Address[] currentAddresses = this.addresses;
        for (int i = 0; i < 7 && (address = currentAddresses[i]) != null; ++i) {
            if (!address.equals(oldAddress)) continue;
            Address[] newAddresses = Arrays.copyOf(currentAddresses, 7);
            newAddresses[i] = newAddress;
            this.addresses = newAddresses;
            this.callPartitionListener(i, oldAddress, newAddress);
            return i;
        }
        return -1;
    }

    void reset() {
        this.addresses = new Address[7];
        this.setMigrating(false);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Partition [").append(this.partitionId).append("]{\n");
        for (int i = 0; i < 7; ++i) {
            Address address = this.addresses[i];
            if (address == null) continue;
            sb.append('\t');
            sb.append(i).append(":").append(address);
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }
}

