/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.logback.extensions;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.helpers.MessageFormatter;

public class LogSanitisingConverter
extends ClassicConverter {
    private static final Pattern ANSI_ESCAPE_PATTERN = Pattern.compile("(?:\\u001B)\\[[\\d;]*[^\\d;]|([\\x00-\\x1F])");

    public String convert(ILoggingEvent event) {
        if (!event.getLevel().isGreaterOrEqual(Level.INFO)) {
            return MessageFormatter.arrayFormat((String)event.getMessage(), (Object[])event.getArgumentArray()).getMessage();
        }
        if (event.getArgumentArray() == null || event.getArgumentArray().length == 0) {
            return this.sanitise(event.getFormattedMessage());
        }
        Object[] sanitisedArguments = new String[event.getArgumentArray().length];
        int index = 0;
        for (Object o : event.getArgumentArray()) {
            String sanitisedString = null;
            if (o != null) {
                String string = !(o instanceof String) ? o.toString() : (String)o;
                sanitisedString = this.sanitise(string);
            }
            sanitisedArguments[index++] = sanitisedString;
        }
        String message = event.getMessage();
        return MessageFormatter.arrayFormat((String)message, (Object[])sanitisedArguments).getMessage();
    }

    private String sanitise(String string) {
        if (null == string) {
            return new String();
        }
        Matcher matcher = ANSI_ESCAPE_PATTERN.matcher(string);
        int lastMatch = 0;
        StringBuilder s = new StringBuilder();
        while (matcher.find()) {
            String substring = string.substring(lastMatch, matcher.start());
            s.append(substring);
            lastMatch = matcher.end();
        }
        if (s.length() != 0) {
            string = s.toString();
        }
        return string;
    }
}

