/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.medialive.model.InputDestination;

@SdkInternalApi
public class InputDestinationMarshaller {
    private static final MarshallingInfo<String> IP_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ip").build();
    private static final MarshallingInfo<String> PORT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("port").build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("url").build();
    private static final InputDestinationMarshaller instance = new InputDestinationMarshaller();

    public static InputDestinationMarshaller getInstance() {
        return instance;
    }

    public void marshall(InputDestination inputDestination, ProtocolMarshaller protocolMarshaller) {
        if (inputDestination == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(inputDestination.getIp(), IP_BINDING);
            protocolMarshaller.marshall(inputDestination.getPort(), PORT_BINDING);
            protocolMarshaller.marshall(inputDestination.getUrl(), URL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

