/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.glacier.model.CSVInput;

@SdkInternalApi
public class CSVInputMarshaller {
    private static final MarshallingInfo<String> FILEHEADERINFO_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileHeaderInfo").build();
    private static final MarshallingInfo<String> COMMENTS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Comments").build();
    private static final MarshallingInfo<String> QUOTEESCAPECHARACTER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QuoteEscapeCharacter").build();
    private static final MarshallingInfo<String> RECORDDELIMITER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordDelimiter").build();
    private static final MarshallingInfo<String> FIELDDELIMITER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FieldDelimiter").build();
    private static final MarshallingInfo<String> QUOTECHARACTER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QuoteCharacter").build();
    private static final CSVInputMarshaller instance = new CSVInputMarshaller();

    public static CSVInputMarshaller getInstance() {
        return instance;
    }

    public void marshall(CSVInput cSVInput, ProtocolMarshaller protocolMarshaller) {
        if (cSVInput == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(cSVInput.getFileHeaderInfo(), FILEHEADERINFO_BINDING);
            protocolMarshaller.marshall(cSVInput.getComments(), COMMENTS_BINDING);
            protocolMarshaller.marshall(cSVInput.getQuoteEscapeCharacter(), QUOTEESCAPECHARACTER_BINDING);
            protocolMarshaller.marshall(cSVInput.getRecordDelimiter(), RECORDDELIMITER_BINDING);
            protocolMarshaller.marshall(cSVInput.getFieldDelimiter(), FIELDDELIMITER_BINDING);
            protocolMarshaller.marshall(cSVInput.getQuoteCharacter(), QUOTECHARACTER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

