/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.ClassicLoadBalancer;
import com.amazonaws.services.ec2.model.ClassicLoadBalancersConfig;
import com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.amazonaws.services.ec2.model.FleetLaunchTemplateSpecification;
import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.InstanceIpv6Address;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.LaunchTemplateConfig;
import com.amazonaws.services.ec2.model.LaunchTemplateOverrides;
import com.amazonaws.services.ec2.model.LoadBalancersConfig;
import com.amazonaws.services.ec2.model.PrivateIpAddressSpecification;
import com.amazonaws.services.ec2.model.RequestSpotFleetRequest;
import com.amazonaws.services.ec2.model.SpotFleetLaunchSpecification;
import com.amazonaws.services.ec2.model.SpotFleetMonitoring;
import com.amazonaws.services.ec2.model.SpotFleetRequestConfigData;
import com.amazonaws.services.ec2.model.SpotFleetTagSpecification;
import com.amazonaws.services.ec2.model.SpotPlacement;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TargetGroup;
import com.amazonaws.services.ec2.model.TargetGroupsConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;

public class RequestSpotFleetRequestMarshaller
implements Marshaller<Request<RequestSpotFleetRequest>, RequestSpotFleetRequest> {
    @Override
    public Request<RequestSpotFleetRequest> marshall(RequestSpotFleetRequest requestSpotFleetRequest) {
        if (requestSpotFleetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RequestSpotFleetRequest> request = new DefaultRequest<RequestSpotFleetRequest>(requestSpotFleetRequest, "AmazonEC2");
        request.addParameter("Action", "RequestSpotFleet");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SpotFleetRequestConfigData spotFleetRequestConfig = requestSpotFleetRequest.getSpotFleetRequestConfig();
        if (spotFleetRequestConfig != null) {
            LoadBalancersConfig loadBalancersConfig;
            SdkInternalList spotFleetRequestConfigDataLaunchTemplateConfigsList;
            Object spotFleetLaunchSpecificationNetworkInterfacesList;
            SdkInternalList spotFleetRequestConfigDataLaunchSpecificationsList;
            if (spotFleetRequestConfig.getAllocationStrategy() != null) {
                request.addParameter("SpotFleetRequestConfig.AllocationStrategy", StringUtils.fromString(spotFleetRequestConfig.getAllocationStrategy()));
            }
            if (spotFleetRequestConfig.getClientToken() != null) {
                request.addParameter("SpotFleetRequestConfig.ClientToken", StringUtils.fromString(spotFleetRequestConfig.getClientToken()));
            }
            if (spotFleetRequestConfig.getExcessCapacityTerminationPolicy() != null) {
                request.addParameter("SpotFleetRequestConfig.ExcessCapacityTerminationPolicy", StringUtils.fromString(spotFleetRequestConfig.getExcessCapacityTerminationPolicy()));
            }
            if (spotFleetRequestConfig.getFulfilledCapacity() != null) {
                request.addParameter("SpotFleetRequestConfig.FulfilledCapacity", StringUtils.fromDouble(spotFleetRequestConfig.getFulfilledCapacity()));
            }
            if (spotFleetRequestConfig.getIamFleetRole() != null) {
                request.addParameter("SpotFleetRequestConfig.IamFleetRole", StringUtils.fromString(spotFleetRequestConfig.getIamFleetRole()));
            }
            if (!(spotFleetRequestConfigDataLaunchSpecificationsList = (SdkInternalList)spotFleetRequestConfig.getLaunchSpecifications()).isEmpty() || !spotFleetRequestConfigDataLaunchSpecificationsList.isAutoConstruct()) {
                int launchSpecificationsListIndex = 1;
                for (Object spotFleetRequestConfigDataLaunchSpecificationsListValue : spotFleetRequestConfigDataLaunchSpecificationsList) {
                    SdkInternalList spotFleetLaunchSpecificationTagSpecificationsList;
                    SpotPlacement placement;
                    SpotFleetMonitoring monitoring;
                    IamInstanceProfileSpecification iamInstanceProfile;
                    SdkInternalList spotFleetLaunchSpecificationBlockDeviceMappingsList;
                    SdkInternalList spotFleetLaunchSpecificationSecurityGroupsList = (SdkInternalList)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getSecurityGroups();
                    if (!spotFleetLaunchSpecificationSecurityGroupsList.isEmpty() || !spotFleetLaunchSpecificationSecurityGroupsList.isAutoConstruct()) {
                        int securityGroupsListIndex = 1;
                        for (Object spotFleetLaunchSpecificationSecurityGroupsListValue : spotFleetLaunchSpecificationSecurityGroupsList) {
                            if (((GroupIdentifier)spotFleetLaunchSpecificationSecurityGroupsListValue).getGroupName() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".GroupSet." + securityGroupsListIndex + ".GroupName", StringUtils.fromString(((GroupIdentifier)spotFleetLaunchSpecificationSecurityGroupsListValue).getGroupName()));
                            }
                            if (((GroupIdentifier)spotFleetLaunchSpecificationSecurityGroupsListValue).getGroupId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".GroupSet." + securityGroupsListIndex + ".GroupId", StringUtils.fromString(((GroupIdentifier)spotFleetLaunchSpecificationSecurityGroupsListValue).getGroupId()));
                            }
                            ++securityGroupsListIndex;
                        }
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getAddressingType() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".AddressingType", StringUtils.fromString(((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getAddressingType()));
                    }
                    if (!(spotFleetLaunchSpecificationBlockDeviceMappingsList = (SdkInternalList)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getBlockDeviceMappings()).isEmpty() || !spotFleetLaunchSpecificationBlockDeviceMappingsList.isAutoConstruct()) {
                        Object spotFleetLaunchSpecificationSecurityGroupsListValue;
                        int blockDeviceMappingsListIndex = 1;
                        spotFleetLaunchSpecificationSecurityGroupsListValue = spotFleetLaunchSpecificationBlockDeviceMappingsList.iterator();
                        while (spotFleetLaunchSpecificationSecurityGroupsListValue.hasNext()) {
                            EbsBlockDevice ebs;
                            BlockDeviceMapping spotFleetLaunchSpecificationBlockDeviceMappingsListValue = (BlockDeviceMapping)spotFleetLaunchSpecificationSecurityGroupsListValue.next();
                            if (spotFleetLaunchSpecificationBlockDeviceMappingsListValue.getDeviceName() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString(spotFleetLaunchSpecificationBlockDeviceMappingsListValue.getDeviceName()));
                            }
                            if (spotFleetLaunchSpecificationBlockDeviceMappingsListValue.getVirtualName() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString(spotFleetLaunchSpecificationBlockDeviceMappingsListValue.getVirtualName()));
                            }
                            if ((ebs = spotFleetLaunchSpecificationBlockDeviceMappingsListValue.getEbs()) != null) {
                                if (ebs.getEncrypted() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean(ebs.getEncrypted()));
                                }
                                if (ebs.getDeleteOnTermination() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean(ebs.getDeleteOnTermination()));
                                }
                                if (ebs.getIops() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger(ebs.getIops()));
                                }
                                if (ebs.getKmsKeyId() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.KmsKeyId", StringUtils.fromString(ebs.getKmsKeyId()));
                                }
                                if (ebs.getSnapshotId() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString(ebs.getSnapshotId()));
                                }
                                if (ebs.getVolumeSize() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger(ebs.getVolumeSize()));
                                }
                                if (ebs.getVolumeType() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString(ebs.getVolumeType()));
                                }
                            }
                            if (spotFleetLaunchSpecificationBlockDeviceMappingsListValue.getNoDevice() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString(spotFleetLaunchSpecificationBlockDeviceMappingsListValue.getNoDevice()));
                            }
                            ++blockDeviceMappingsListIndex;
                        }
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getEbsOptimized() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".EbsOptimized", StringUtils.fromBoolean(((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getEbsOptimized()));
                    }
                    if ((iamInstanceProfile = ((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getIamInstanceProfile()) != null) {
                        if (iamInstanceProfile.getArn() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".IamInstanceProfile.Arn", StringUtils.fromString(iamInstanceProfile.getArn()));
                        }
                        if (iamInstanceProfile.getName() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".IamInstanceProfile.Name", StringUtils.fromString(iamInstanceProfile.getName()));
                        }
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getImageId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".ImageId", StringUtils.fromString(((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getImageId()));
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getInstanceType() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceType", StringUtils.fromString(((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getInstanceType()));
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getKernelId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".KernelId", StringUtils.fromString(((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getKernelId()));
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getKeyName() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".KeyName", StringUtils.fromString(((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getKeyName()));
                    }
                    if ((monitoring = ((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getMonitoring()) != null && monitoring.getEnabled() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".Monitoring.Enabled", StringUtils.fromBoolean(monitoring.getEnabled()));
                    }
                    if (!((ArrayList)(spotFleetLaunchSpecificationNetworkInterfacesList = (SdkInternalList)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getNetworkInterfaces())).isEmpty() || !((SdkInternalList)spotFleetLaunchSpecificationNetworkInterfacesList).isAutoConstruct()) {
                        int networkInterfacesListIndex = 1;
                        Iterator iterator = ((ArrayList)spotFleetLaunchSpecificationNetworkInterfacesList).iterator();
                        while (iterator.hasNext()) {
                            SdkInternalList instanceNetworkInterfaceSpecificationPrivateIpAddressesList;
                            SdkInternalList instanceNetworkInterfaceSpecificationIpv6AddressesList;
                            SdkInternalList instanceNetworkInterfaceSpecificationGroupsList;
                            InstanceNetworkInterfaceSpecification spotFleetLaunchSpecificationNetworkInterfacesListValue = (InstanceNetworkInterfaceSpecification)iterator.next();
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getAssociatePublicIpAddress() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringUtils.fromBoolean(spotFleetLaunchSpecificationNetworkInterfacesListValue.getAssociatePublicIpAddress()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getDeleteOnTermination() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".DeleteOnTermination", StringUtils.fromBoolean(spotFleetLaunchSpecificationNetworkInterfacesListValue.getDeleteOnTermination()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getDescription() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".Description", StringUtils.fromString(spotFleetLaunchSpecificationNetworkInterfacesListValue.getDescription()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getDeviceIndex() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".DeviceIndex", StringUtils.fromInteger(spotFleetLaunchSpecificationNetworkInterfacesListValue.getDeviceIndex()));
                            }
                            if (!(instanceNetworkInterfaceSpecificationGroupsList = (SdkInternalList)spotFleetLaunchSpecificationNetworkInterfacesListValue.getGroups()).isEmpty() || !instanceNetworkInterfaceSpecificationGroupsList.isAutoConstruct()) {
                                int groupsListIndex = 1;
                                for (Object instanceNetworkInterfaceSpecificationGroupsListValue : instanceNetworkInterfaceSpecificationGroupsList) {
                                    if (instanceNetworkInterfaceSpecificationGroupsListValue != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)instanceNetworkInterfaceSpecificationGroupsListValue));
                                    }
                                    ++groupsListIndex;
                                }
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getIpv6AddressCount() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".Ipv6AddressCount", StringUtils.fromInteger(spotFleetLaunchSpecificationNetworkInterfacesListValue.getIpv6AddressCount()));
                            }
                            if (!(instanceNetworkInterfaceSpecificationIpv6AddressesList = (SdkInternalList)spotFleetLaunchSpecificationNetworkInterfacesListValue.getIpv6Addresses()).isEmpty() || !instanceNetworkInterfaceSpecificationIpv6AddressesList.isAutoConstruct()) {
                                Object instanceNetworkInterfaceSpecificationGroupsListValue;
                                int ipv6AddressesListIndex = 1;
                                instanceNetworkInterfaceSpecificationGroupsListValue = instanceNetworkInterfaceSpecificationIpv6AddressesList.iterator();
                                while (instanceNetworkInterfaceSpecificationGroupsListValue.hasNext()) {
                                    InstanceIpv6Address instanceNetworkInterfaceSpecificationIpv6AddressesListValue = (InstanceIpv6Address)instanceNetworkInterfaceSpecificationGroupsListValue.next();
                                    if (instanceNetworkInterfaceSpecificationIpv6AddressesListValue.getIpv6Address() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".Ipv6Addresses." + ipv6AddressesListIndex + ".Ipv6Address", StringUtils.fromString(instanceNetworkInterfaceSpecificationIpv6AddressesListValue.getIpv6Address()));
                                    }
                                    ++ipv6AddressesListIndex;
                                }
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getNetworkInterfaceId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".NetworkInterfaceId", StringUtils.fromString(spotFleetLaunchSpecificationNetworkInterfacesListValue.getNetworkInterfaceId()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getPrivateIpAddress() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".PrivateIpAddress", StringUtils.fromString(spotFleetLaunchSpecificationNetworkInterfacesListValue.getPrivateIpAddress()));
                            }
                            if (!(instanceNetworkInterfaceSpecificationPrivateIpAddressesList = (SdkInternalList)spotFleetLaunchSpecificationNetworkInterfacesListValue.getPrivateIpAddresses()).isEmpty() || !instanceNetworkInterfaceSpecificationPrivateIpAddressesList.isAutoConstruct()) {
                                int privateIpAddressesListIndex = 1;
                                for (PrivateIpAddressSpecification instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue : instanceNetworkInterfaceSpecificationPrivateIpAddressesList) {
                                    if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrimary() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringUtils.fromBoolean(instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrimary()));
                                    }
                                    if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrivateIpAddress() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils.fromString(instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrivateIpAddress()));
                                    }
                                    ++privateIpAddressesListIndex;
                                }
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getSecondaryPrivateIpAddressCount() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringUtils.fromInteger(spotFleetLaunchSpecificationNetworkInterfacesListValue.getSecondaryPrivateIpAddressCount()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.getSubnetId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".SubnetId", StringUtils.fromString(spotFleetLaunchSpecificationNetworkInterfacesListValue.getSubnetId()));
                            }
                            ++networkInterfacesListIndex;
                        }
                    }
                    if ((placement = ((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getPlacement()) != null) {
                        if (placement.getAvailabilityZone() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".Placement.AvailabilityZone", StringUtils.fromString(placement.getAvailabilityZone()));
                        }
                        if (placement.getGroupName() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".Placement.GroupName", StringUtils.fromString(placement.getGroupName()));
                        }
                        if (placement.getTenancy() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".Placement.Tenancy", StringUtils.fromString(placement.getTenancy()));
                        }
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getRamdiskId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".RamdiskId", StringUtils.fromString(((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getRamdiskId()));
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getSpotPrice() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".SpotPrice", StringUtils.fromString(((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getSpotPrice()));
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getSubnetId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".SubnetId", StringUtils.fromString(((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getSubnetId()));
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getUserData() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".UserData", StringUtils.fromString(((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getUserData()));
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getWeightedCapacity() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".WeightedCapacity", StringUtils.fromDouble(((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getWeightedCapacity()));
                    }
                    if (!(spotFleetLaunchSpecificationTagSpecificationsList = (SdkInternalList)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).getTagSpecifications()).isEmpty() || !spotFleetLaunchSpecificationTagSpecificationsList.isAutoConstruct()) {
                        int tagSpecificationsListIndex = 1;
                        for (SpotFleetTagSpecification spotFleetLaunchSpecificationTagSpecificationsListValue : spotFleetLaunchSpecificationTagSpecificationsList) {
                            SdkInternalList spotFleetTagSpecificationTagsList;
                            if (spotFleetLaunchSpecificationTagSpecificationsListValue.getResourceType() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".TagSpecificationSet." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(spotFleetLaunchSpecificationTagSpecificationsListValue.getResourceType()));
                            }
                            if (!(spotFleetTagSpecificationTagsList = (SdkInternalList)spotFleetLaunchSpecificationTagSpecificationsListValue.getTags()).isEmpty() || !spotFleetTagSpecificationTagsList.isAutoConstruct()) {
                                int tagsListIndex = 1;
                                for (Tag spotFleetTagSpecificationTagsListValue : spotFleetTagSpecificationTagsList) {
                                    if (spotFleetTagSpecificationTagsListValue.getKey() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".TagSpecificationSet." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(spotFleetTagSpecificationTagsListValue.getKey()));
                                    }
                                    if (spotFleetTagSpecificationTagsListValue.getValue() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".TagSpecificationSet." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(spotFleetTagSpecificationTagsListValue.getValue()));
                                    }
                                    ++tagsListIndex;
                                }
                            }
                            ++tagSpecificationsListIndex;
                        }
                    }
                    ++launchSpecificationsListIndex;
                }
            }
            if (!(spotFleetRequestConfigDataLaunchTemplateConfigsList = (SdkInternalList)spotFleetRequestConfig.getLaunchTemplateConfigs()).isEmpty() || !spotFleetRequestConfigDataLaunchTemplateConfigsList.isAutoConstruct()) {
                int launchTemplateConfigsListIndex = 1;
                for (LaunchTemplateConfig spotFleetRequestConfigDataLaunchTemplateConfigsListValue : spotFleetRequestConfigDataLaunchTemplateConfigsList) {
                    Object launchTemplateConfigOverridesList;
                    FleetLaunchTemplateSpecification launchTemplateSpecification = spotFleetRequestConfigDataLaunchTemplateConfigsListValue.getLaunchTemplateSpecification();
                    if (launchTemplateSpecification != null) {
                        if (launchTemplateSpecification.getLaunchTemplateId() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.LaunchTemplateId", StringUtils.fromString(launchTemplateSpecification.getLaunchTemplateId()));
                        }
                        if (launchTemplateSpecification.getLaunchTemplateName() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.LaunchTemplateName", StringUtils.fromString(launchTemplateSpecification.getLaunchTemplateName()));
                        }
                        if (launchTemplateSpecification.getVersion() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.Version", StringUtils.fromString(launchTemplateSpecification.getVersion()));
                        }
                    }
                    if (!((ArrayList)(launchTemplateConfigOverridesList = (SdkInternalList)spotFleetRequestConfigDataLaunchTemplateConfigsListValue.getOverrides())).isEmpty() || !((SdkInternalList)launchTemplateConfigOverridesList).isAutoConstruct()) {
                        int overridesListIndex = 1;
                        spotFleetLaunchSpecificationNetworkInterfacesList = ((ArrayList)launchTemplateConfigOverridesList).iterator();
                        while (spotFleetLaunchSpecificationNetworkInterfacesList.hasNext()) {
                            LaunchTemplateOverrides launchTemplateConfigOverridesListValue = (LaunchTemplateOverrides)spotFleetLaunchSpecificationNetworkInterfacesList.next();
                            if (launchTemplateConfigOverridesListValue.getInstanceType() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceType", StringUtils.fromString(launchTemplateConfigOverridesListValue.getInstanceType()));
                            }
                            if (launchTemplateConfigOverridesListValue.getSpotPrice() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".SpotPrice", StringUtils.fromString(launchTemplateConfigOverridesListValue.getSpotPrice()));
                            }
                            if (launchTemplateConfigOverridesListValue.getSubnetId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".SubnetId", StringUtils.fromString(launchTemplateConfigOverridesListValue.getSubnetId()));
                            }
                            if (launchTemplateConfigOverridesListValue.getAvailabilityZone() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".AvailabilityZone", StringUtils.fromString(launchTemplateConfigOverridesListValue.getAvailabilityZone()));
                            }
                            if (launchTemplateConfigOverridesListValue.getWeightedCapacity() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".WeightedCapacity", StringUtils.fromDouble(launchTemplateConfigOverridesListValue.getWeightedCapacity()));
                            }
                            ++overridesListIndex;
                        }
                    }
                    ++launchTemplateConfigsListIndex;
                }
            }
            if (spotFleetRequestConfig.getSpotPrice() != null) {
                request.addParameter("SpotFleetRequestConfig.SpotPrice", StringUtils.fromString(spotFleetRequestConfig.getSpotPrice()));
            }
            if (spotFleetRequestConfig.getTargetCapacity() != null) {
                request.addParameter("SpotFleetRequestConfig.TargetCapacity", StringUtils.fromInteger(spotFleetRequestConfig.getTargetCapacity()));
            }
            if (spotFleetRequestConfig.getTerminateInstancesWithExpiration() != null) {
                request.addParameter("SpotFleetRequestConfig.TerminateInstancesWithExpiration", StringUtils.fromBoolean(spotFleetRequestConfig.getTerminateInstancesWithExpiration()));
            }
            if (spotFleetRequestConfig.getType() != null) {
                request.addParameter("SpotFleetRequestConfig.Type", StringUtils.fromString(spotFleetRequestConfig.getType()));
            }
            if (spotFleetRequestConfig.getValidFrom() != null) {
                request.addParameter("SpotFleetRequestConfig.ValidFrom", StringUtils.fromDate(spotFleetRequestConfig.getValidFrom()));
            }
            if (spotFleetRequestConfig.getValidUntil() != null) {
                request.addParameter("SpotFleetRequestConfig.ValidUntil", StringUtils.fromDate(spotFleetRequestConfig.getValidUntil()));
            }
            if (spotFleetRequestConfig.getReplaceUnhealthyInstances() != null) {
                request.addParameter("SpotFleetRequestConfig.ReplaceUnhealthyInstances", StringUtils.fromBoolean(spotFleetRequestConfig.getReplaceUnhealthyInstances()));
            }
            if (spotFleetRequestConfig.getInstanceInterruptionBehavior() != null) {
                request.addParameter("SpotFleetRequestConfig.InstanceInterruptionBehavior", StringUtils.fromString(spotFleetRequestConfig.getInstanceInterruptionBehavior()));
            }
            if ((loadBalancersConfig = spotFleetRequestConfig.getLoadBalancersConfig()) != null) {
                SdkInternalList targetGroupsConfigTargetGroupsList;
                TargetGroupsConfig targetGroupsConfig;
                SdkInternalList classicLoadBalancersConfigClassicLoadBalancersList;
                ClassicLoadBalancersConfig classicLoadBalancersConfig = loadBalancersConfig.getClassicLoadBalancersConfig();
                if (!(classicLoadBalancersConfig == null || (classicLoadBalancersConfigClassicLoadBalancersList = (SdkInternalList)classicLoadBalancersConfig.getClassicLoadBalancers()).isEmpty() && classicLoadBalancersConfigClassicLoadBalancersList.isAutoConstruct())) {
                    int classicLoadBalancersListIndex = 1;
                    for (ClassicLoadBalancer classicLoadBalancersConfigClassicLoadBalancersListValue : classicLoadBalancersConfigClassicLoadBalancersList) {
                        if (classicLoadBalancersConfigClassicLoadBalancersListValue.getName() != null) {
                            request.addParameter("SpotFleetRequestConfig.LoadBalancersConfig.ClassicLoadBalancersConfig.ClassicLoadBalancers." + classicLoadBalancersListIndex + ".Name", StringUtils.fromString(classicLoadBalancersConfigClassicLoadBalancersListValue.getName()));
                        }
                        ++classicLoadBalancersListIndex;
                    }
                }
                if (!((targetGroupsConfig = loadBalancersConfig.getTargetGroupsConfig()) == null || (targetGroupsConfigTargetGroupsList = (SdkInternalList)targetGroupsConfig.getTargetGroups()).isEmpty() && targetGroupsConfigTargetGroupsList.isAutoConstruct())) {
                    int targetGroupsListIndex = 1;
                    for (TargetGroup targetGroupsConfigTargetGroupsListValue : targetGroupsConfigTargetGroupsList) {
                        if (targetGroupsConfigTargetGroupsListValue.getArn() != null) {
                            request.addParameter("SpotFleetRequestConfig.LoadBalancersConfig.TargetGroupsConfig.TargetGroups." + targetGroupsListIndex + ".Arn", StringUtils.fromString(targetGroupsConfigTargetGroupsListValue.getArn()));
                        }
                        ++targetGroupsListIndex;
                    }
                }
            }
        }
        return request;
    }
}

