/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2017-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.chronos.provider.composition.impl;

import com.openexchange.capabilities.CapabilityChecker;
import com.openexchange.config.cascade.ConfigView;
import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.exception.OXException;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;

/**
 * {@link CalendarPrintingCapabilityChecker}
 *
 * @author <a href="mailto:tobias.friedrich@open-xchange.com">Tobias Friedrich</a>
 * @since v7.10.3
 */
public class CalendarPrintingCapabilityChecker implements CapabilityChecker {

    public static final String CAPABILITY_NAME = "calendar-printing";

    private final ConfigViewFactory configViewFactory;

    /**
     * Initializes a new {@link CalendarPrintingCapabilityChecker}.
     * 
     * @param configViewFactory A reference to the config view factory
     */
    public CalendarPrintingCapabilityChecker(ConfigViewFactory configViewFactory) {
        super();
        this.configViewFactory = configViewFactory;
    }

    @Override
    public boolean isEnabled(String capability, Session session) throws OXException {
        if (CAPABILITY_NAME.equals(capability)) {
            ServerSession serverSession = ServerSessionAdapter.valueOf(session);
            if (serverSession.isAnonymous() || false == serverSession.getUserPermissionBits().hasCalendar()) {
                return false;
            }
            /*
             * enabled if either absent, or explicitly true
             */
            ConfigView view = configViewFactory.getView(session.getUserId(), session.getContextId());
            return view.opt("com.openexchange.capability.calendar-printing", Boolean.class, Boolean.TRUE).booleanValue();
        }
        return true;
    }

}
