/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.chronos.itip.generators.changes;

import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import com.openexchange.chronos.Event;
import com.openexchange.chronos.EventField;
import com.openexchange.chronos.itip.generators.Sentence;
import com.openexchange.chronos.itip.tools.ITipEventUpdate;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;

/**
 * {@link ChangeDescriptionGenerator}
 *
 * @author <a href="mailto:francisco.laguna@open-xchange.com">Francisco Laguna</a>
 */
public interface ChangeDescriptionGenerator {

    /**
     * An arrays of fields for which human readable {@link Sentence}s can be build
     * 
     * @return An array of processible {@link EventField}s
     */
    public EventField[] getFields();

    /**
     * Generate human readable sentences for specific fields on given diff
     * 
     * @param ctx The {@link Context}
     * @param original The original {@link Event}
     * @param updated The updated {@link Event}
     * @param diff The {@link ITipEventUpdate} of the events
     * @param locale The {@link Locale} to get the human readable sentences in
     * @param timezone The {@link TimeZone} of the user
     * @param recipientUserId The user's Id or '0' if external
     * @return A {@link List} of human readable {@link Sentence} describing the diff
     * @throws OXException In case sentences can't be generated
     * @see #getFields()
     */
    @SuppressWarnings("unused")
    default public List<Sentence> getDescriptions(Context ctx, Event original, Event updated, ITipEventUpdate diff, Locale locale, TimeZone timezone, int recipientUserId) throws OXException {
        return getDescriptions(ctx, original, updated, diff, locale, timezone);
    }

    /**
     * Generate human readable sentences for specific fields on given diff
     * 
     * @param ctx The {@link Context}
     * @param original The original {@link Event}
     * @param updated The updated {@link Event}
     * @param diff The {@link ITipEventUpdate} of the events
     * @param locale The {@link Locale} to get the human readable sentences in
     * @param timezone The {@link TimeZone} of the user
     * @param participantCtxId The user's context Id or '0' if external
     * @param participantUserId The user's Id or '0' if external
     * @return A {@link List} of human readable {@link Sentence} describing the diff
     * @throws OXException In case sentences can't be generated
     * @see #getFields()
     */
    List<Sentence> getDescriptions(Context ctx, Event original, Event updated, ITipEventUpdate diff, Locale locale, TimeZone timezone) throws OXException;
}
