/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid;

import io.github.bucket4j.serialization.DeserializationAdapter;
import io.github.bucket4j.serialization.SerializationAdapter;
import io.github.bucket4j.serialization.SerializationHandle;
import java.io.IOException;
import java.io.Serializable;

public class CommandResult<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final CommandResult<?> NOT_FOUND = new CommandResult<Object>(null, true);
    private T data;
    private boolean bucketNotFound;
    public static SerializationHandle<CommandResult<?>> SERIALIZATION_HANDLE = new SerializationHandle<CommandResult<?>>(){

        @Override
        public <S> CommandResult<?> deserialize(DeserializationAdapter<S> adapter, S input) throws IOException {
            boolean isBucketNotFound = adapter.readBoolean(input);
            return isBucketNotFound ? CommandResult.bucketNotFound() : CommandResult.success((Serializable)adapter.readObject(input));
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, CommandResult<?> result) throws IOException {
            adapter.writeBoolean(output, ((CommandResult)result).bucketNotFound);
            if (!((CommandResult)result).bucketNotFound) {
                adapter.writeObject(output, ((CommandResult)result).data);
            }
        }

        @Override
        public int getTypeId() {
            return 14;
        }

        @Override
        public Class<CommandResult<?>> getSerializedType() {
            return CommandResult.class;
        }
    };

    public CommandResult(T data, boolean bucketNotFound) {
        this.data = data;
        this.bucketNotFound = bucketNotFound;
    }

    public static <R extends Serializable> CommandResult<R> success(R data) {
        return new CommandResult<R>(data, false);
    }

    public static <R extends Serializable> CommandResult<R> bucketNotFound() {
        return NOT_FOUND;
    }

    public T getData() {
        return this.data;
    }

    public boolean isBucketNotFound() {
        return this.bucketNotFound;
    }
}

