/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.io.IOException;
import org.apache.sis.internal.netcdf.GridGeometry;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.netcdf.AttributeNames;
import org.apache.sis.util.ArraysExt;

public final class Axis {
    public final AttributeNames.Dimension attributeNames;
    public final int[] sourceDimensions;
    public final int[] sourceSizes;

    public Axis(GridGeometry gridGeometry, Object object, AttributeNames.Dimension dimension, int[] nArray, int[] nArray2) throws IOException, DataStoreException {
        this.attributeNames = dimension;
        this.sourceDimensions = nArray;
        this.sourceSizes = nArray2;
        if (nArray.length == 2) {
            int n = nArray2[0];
            int n2 = nArray2[1];
            int n3 = n / 2;
            int n4 = n2 / 2;
            double d = (gridGeometry.coordinateForAxis(object, 0, n4) - gridGeometry.coordinateForAxis(object, n - 1, n4)) / (double)n;
            double d2 = (gridGeometry.coordinateForAxis(object, n3, 0) - gridGeometry.coordinateForAxis(object, n3, n2 - 1)) / (double)n2;
            if (Math.abs(d2) > Math.abs(d)) {
                nArray2[0] = n2;
                nArray2[1] = n;
                ArraysExt.swap((int[])nArray, (int)0, (int)1);
            }
        }
    }
}

