/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.tnef.mime;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import net.freeutils.tnef.Message;
import net.freeutils.tnef.TNEFInputStream;
import net.freeutils.tnef.TNEFUtils;
import net.freeutils.tnef.mime.ContactConverter;
import net.freeutils.tnef.mime.Converter;
import net.freeutils.tnef.mime.MessageConverter;
import net.freeutils.tnef.mime.ReadReceiptConverter;
import net.freeutils.tnef.mime.TNEFMimeBodyPart;
import net.freeutils.tnef.mime.TNEFMimeMessage;

public class TNEFMime {
    static Converter[] converters = new Converter[]{new ContactConverter(), new ReadReceiptConverter(), new MessageConverter()};

    public static void setConverters(Converter ... converters) {
        TNEFMime.converters = converters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean extractTNEF(String mimeFilename, String tnefFilename) throws IOException, MessagingException {
        Properties props = new Properties();
        Session session = Session.getInstance((Properties)props, null);
        FileInputStream fis = new FileInputStream(mimeFilename);
        try {
            boolean bl = TNEFMime.extractTNEF((Part)new MimeMessage(session, (InputStream)fis), tnefFilename);
            return bl;
        }
        finally {
            fis.close();
        }
    }

    public static boolean extractTNEF(Part part, String tnefFilename) throws IOException, MessagingException {
        boolean extracted = false;
        if (part.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)part.getContent();
            int count = mp.getCount();
            for (int i = 0; i < count; ++i) {
                if (!TNEFMime.extractTNEF((Part)mp.getBodyPart(i), tnefFilename)) continue;
                extracted = true;
            }
        } else if (TNEFUtils.isTNEFMimeType(part.getContentType())) {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tnefFilename));
            InputStream in = part.getInputStream();
            TNEFUtils.transfer(in, out, -1L, true, true);
            extracted = true;
        }
        return extracted;
    }

    public static MimeBodyPart addTextPart(Multipart mp, String text, String contentType) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        part.setText(text, "UTF-8");
        part.setHeader("Content-Type", contentType + "; charset=utf-8");
        mp.addBodyPart((BodyPart)part);
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TNEFMimeMessage convert(Session session, TNEFInputStream in) throws IOException, MessagingException {
        Message message = new Message(in);
        try {
            TNEFMimeMessage tNEFMimeMessage = TNEFMime.convert(session, message);
            return tNEFMimeMessage;
        }
        finally {
            message.close();
        }
    }

    public static TNEFMimeMessage convert(Session session, Message message) throws IOException, MessagingException {
        TNEFMimeMessage mime = new TNEFMimeMessage(session);
        for (Converter converter : converters) {
            if (!converter.canConvert(message)) continue;
            mime = converter.convert(message, mime);
            break;
        }
        mime.saveChanges();
        return mime;
    }

    public static MimeMessage convert(Session session, MimeMessage message) throws IOException, MessagingException {
        return TNEFMime.convert(session, message, true);
    }

    public static MimeMessage convert(Session session, MimeMessage message, boolean embed) throws IOException, MessagingException {
        message = (MimeMessage)TNEFMime.convert(session, (Part)message, embed);
        message.saveChanges();
        return message;
    }

    public static Part convert(Session session, Part part) throws IOException, MessagingException {
        return TNEFMime.convert(session, part, true);
    }

    public static Part convert(Session session, Part part, boolean embed) throws IOException, MessagingException {
        if (part.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)part.getContent();
            int count = mp.getCount();
            for (int i = 0; i < count; ++i) {
                Part convertedPart;
                BodyPart mpPart = mp.getBodyPart(i);
                if (mpPart == (convertedPart = TNEFMime.convert(session, (Part)mpPart))) continue;
                if (!embed) {
                    return convertedPart;
                }
                mp.removeBodyPart(i);
                TNEFMimeBodyPart newPart = new TNEFMimeBodyPart();
                newPart.setDataHandler(new DataHandler((Object)convertedPart, "message/rfc822"));
                mp.addBodyPart((BodyPart)newPart, i);
            }
            part.setContent(mp);
        } else if (TNEFUtils.isTNEFMimeType(part.getContentType())) {
            TNEFInputStream in = new TNEFInputStream(part.getInputStream());
            if (part instanceof MimeMessage) {
                MimeMessage mm = (MimeMessage)part;
                TNEFMimeMessage converted = TNEFMime.convert(session, in);
                mm.removeHeader("Content-Type");
                mm.removeHeader("Content-Transfer-Encoding");
                mm.removeHeader("Content-Disposition");
                mm.setContent(converted.getContent(), converted.getContentType());
            } else {
                part = TNEFMime.convert(session, in);
            }
        }
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        block18: {
            String options;
            String usage = "Usage:\n\n  java net.freeutils.tnef.mime.TNEFMime -<e|c|w> <infile> <outfile>\n\nOptions:\n\n  e Extract the TNEF attachment from a MIME file.\n  c Convert a MIME file containing a TNEF attachment to a MIME file\n    with a nested rfc822 message.\n  w Convert a TNEF attachment to a MIME file.\n\nExamples:\n\n  java net.freeutils.tnef.mime.TNEFMime -e c:\\temp\\1.mime c:\\temp\\winmail.dat\n  java net.freeutils.tnef.mime.TNEFMime -c c:\\temp\\1.mime c:\\temp\\2.mime\n  java net.freeutils.tnef.mime.TNEFMime -w c:\\temp\\winmail.dat c:\\temp\\1.mime\n";
            if (args.length < 3) {
                System.out.println(usage);
                System.exit(1);
            }
            if ((options = args[0].toLowerCase()).startsWith("-") || options.startsWith("/")) {
                options = options.substring(1).trim();
            }
            String infile = args[1];
            String outfile = args[2];
            System.out.println("Processing file " + infile);
            Session session = Session.getInstance((Properties)new Properties());
            FileInputStream in = null;
            FileOutputStream out = null;
            if ("e".equals(options)) {
                TNEFMime.extractTNEF(infile, outfile);
            } else if ("c".equals(options)) {
                in = new FileInputStream(infile);
                MimeMessage mime = new MimeMessage(session, (InputStream)in);
                out = new FileOutputStream(outfile);
                mime = TNEFMime.convert(session, mime);
                mime.writeTo((OutputStream)out);
            } else if ("w".equals(options)) {
                in = new FileInputStream(infile);
                TNEFInputStream tin = new TNEFInputStream(in);
                out = new FileOutputStream(outfile);
                TNEFMimeMessage mime = TNEFMime.convert(session, tin);
                mime.writeTo(out);
            } else {
                System.out.println("\nInvalid option: " + options);
                System.out.println(usage);
                System.exit(1);
            }
            System.out.println("Done.");
            try {
                TNEFUtils.closeAll((Closeable[])new Closeable[]{in, out});
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            break block18;
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        TNEFUtils.closeAll((Closeable[])new Closeable[]{in, out});
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    TNEFUtils.closeAll((Closeable[])new Closeable[]{in, out});
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }
}

