/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.ArrayFSImpl;
import org.apache.uima.jcas.cas.SelectViaCopyToArray;
import org.apache.uima.jcas.cas.TOP;

public final class FSArray<T extends FeatureStructure>
extends TOP
implements ArrayFSImpl<T>,
Iterable<T>,
SelectViaCopyToArray<T> {
    public static final String _TypeName = "uima.cas.FSArray";
    public static final int typeIndexID;
    public static final int type;
    private final TOP[] theArray;

    @Override
    public int getTypeIndexID() {
        return typeIndexID;
    }

    private FSArray() {
        this.theArray = null;
    }

    public FSArray(JCas jcas, int length) {
        super(jcas);
        this._casView.validateArraySize(length);
        this.theArray = new TOP[length];
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
        if (this._casView.isId2Fs()) {
            this._casView.adjustLastFsV2Size_arrays(length);
        }
    }

    public FSArray(TypeImpl t, CASImpl c, int length) {
        super(t, c);
        this._casView.validateArraySize(length);
        this.theArray = new TOP[length];
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
        if (this._casView.isId2Fs()) {
            this._casView.adjustLastFsV2Size_arrays(length);
        }
    }

    @Override
    public <U extends TOP> U get(int i) {
        return (U)this._maybeGetPearFs(this.theArray[i]);
    }

    TOP get_without_PEAR_conversion(int i) {
        return this.theArray[i];
    }

    @Override
    public void set(int i, T av) {
        TOP v = (TOP)av;
        if (v != null && this._casView.getBaseCAS() != v._casView.getBaseCAS()) {
            throw new CASRuntimeException("FS_NOT_MEMBER_OF_CAS", v, v._casView, this._casView);
        }
        this.theArray[i] = this._maybeGetBaseForPearFs(v);
        this._casView.maybeLogArrayUpdate(this, null, i);
    }

    void set_without_PEAR_conversion(int i, TOP v) {
        this.theArray[i] = v;
        this._casView.maybeLogArrayUpdate(this, null, i);
    }

    @Override
    public int size() {
        return this.theArray.length;
    }

    @Override
    public <U extends FeatureStructure> void copyFromArray(U[] src, int srcPos, int destPos, int length) {
        int srcEnd = srcPos + length;
        int destEnd = destPos + length;
        if (srcPos < 0 || srcEnd > src.length || destEnd > this.size()) {
            throw new ArrayIndexOutOfBoundsException(String.format("FSArray.copyFromArray, srcPos: %,d destPos: %,d length: %,d", srcPos, destPos, length));
        }
        while (srcPos < srcEnd && destPos < destEnd) {
            this.set(destPos++, (T)src[srcPos++]);
        }
    }

    @Override
    public <U extends FeatureStructure> void copyToArray(int srcPos, U[] dest, int destPos, int length) {
        int srcEnd = srcPos + length;
        int destEnd = destPos + length;
        if (srcPos < 0 || srcEnd > this.size() || destEnd > dest.length) {
            throw new ArrayIndexOutOfBoundsException(String.format("FSArray.copyToArray, srcPos: %,d destPos: %,d length: %,d", srcPos, destPos, length));
        }
        while (srcPos < srcEnd && destPos < destEnd) {
            dest[destPos++] = this._maybeGetPearFs(this.get(srcPos++));
        }
    }

    @Override
    public FeatureStructure[] toArray() {
        FeatureStructure[] r = new FeatureStructure[this.size()];
        this.copyToArray(0, r, 0, this.size());
        return r;
    }

    @Override
    public FeatureStructure[] _toArrayForSelect() {
        return this.toArray();
    }

    @Override
    public void copyFromArray(String[] src, int srcPos, int destPos, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copyToArray(int srcPos, String[] dest, int destPos, int length) {
        this._casView.checkArrayBounds(this.theArray.length, srcPos, length);
        for (int i = 0; i < length; ++i) {
            TOP fs = this._maybeGetPearFs(this.theArray[i + srcPos]);
            dest[i + destPos] = fs == null ? null : ((Object)fs).toString();
        }
    }

    public TOP[] _getTheArray() {
        return this.theArray;
    }

    @Override
    public void copyValuesFrom(CommonArrayFS<T> v) {
        FSArray bv = (FSArray)v;
        System.arraycopy(bv.theArray, 0, this.theArray, 0, this.theArray.length);
        this._casView.maybeLogArrayUpdates(this, 0, this.size());
    }

    public static <U extends FeatureStructure> FSArray<U> create(JCas jcas, FeatureStructure[] a) {
        FSArray fsa = new FSArray(jcas, a.length);
        fsa.copyFromArray(a, 0, 0, a.length);
        return fsa;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < FSArray.this.size();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return FSArray.this.get(this.i++);
            }
        };
    }

    @Override
    public Spliterator<T> spliterator() {
        return Arrays.spliterator(this.theArray);
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public boolean contains(Object o) {
        if (null == o) {
            for (TOP e : this.theArray) {
                if (e != null) continue;
                return true;
            }
            return false;
        }
        if (!(o instanceof TOP)) {
            return false;
        }
        TOP item = (TOP)o;
        for (TOP e : this.theArray) {
            if (!item.equals(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <U extends TOP> U[] toArray(U[] a) {
        int sz = this.size();
        if (a.length < sz) {
            return (TOP[])Arrays.copyOf(this.theArray, sz, a.getClass());
        }
        System.arraycopy(this.theArray, 0, a, 0, this.size());
        return a;
    }

    static {
        type = typeIndexID = JCasRegistry.register(FSArray.class);
    }
}

