/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.impl;

import org.apache.uima.UimaContext;
import org.apache.uima.UimaContextHolder;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.ComponentInfo;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.internal.util.function.Runnable_withException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.impl.CasManager_impl;

public class Util {
    public static CASImpl getStartingView(CAS cas, boolean sofaAware, ComponentInfo componentInfo) {
        cas.setCurrentComponentInfo(componentInfo);
        CASImpl ci = (CASImpl)cas.getView("_InitialView");
        return ci;
    }

    public static AbstractCas setupViewSwitchClassLoadersLockCas(CAS cas, boolean sofaAware, ComponentInfo componentInfo, ResourceManager resourceManager, Class<? extends AbstractCas> casInterface) {
        CASImpl ci = Util.getStartingView(cas, sofaAware, componentInfo);
        AbstractCas r = CasManager_impl.getCasInterfaceStatic(ci, casInterface);
        ci.switchClassLoaderLockCasCL(resourceManager.getExtensionClassLoader());
        return r;
    }

    public static <T extends AbstractCas> T setupViewSwitchClassLoaders(CAS cas, boolean sofaAware, ComponentInfo componentInfo, ResourceManager resourceManager, Class<T> casInterface) {
        CASImpl ci = Util.getStartingView(cas, sofaAware, componentInfo);
        T r = CasManager_impl.getCasInterfaceStatic(ci, casInterface);
        return r;
    }

    public static void preserveContextHolder(Runnable userCode) {
        UimaContext prevContext = UimaContextHolder.getContext();
        try {
            userCode.run();
        }
        finally {
            UimaContextHolder.setContext(prevContext);
        }
    }

    public static void withContextHolder(UimaContext context, Runnable userCode) {
        UimaContext prevContext = UimaContextHolder.setContext(context);
        try {
            userCode.run();
        }
        finally {
            UimaContextHolder.setContext(prevContext);
        }
    }

    public static void withContextHolderX(UimaContext context, Runnable_withException userCode) throws Exception {
        UimaContext prevContext = UimaContextHolder.setContext(context);
        try {
            userCode.run();
        }
        finally {
            UimaContextHolder.setContext(prevContext);
        }
    }
}

