/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.Comparator;
import java.util.NoSuchElementException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.LowLevelIterator_empty;
import org.apache.uima.jcas.cas.TOP;

public interface LowLevelIterator<T extends FeatureStructure>
extends FSIterator<T> {
    public static final LowLevelIterator<FeatureStructure> FS_ITERATOR_LOW_LEVEL_EMPTY = new LowLevelIterator_empty<FeatureStructure>();
    public static final boolean IS_ORDERED = false;

    default public int ll_get() throws NoSuchElementException {
        return this.get()._id();
    }

    default public void moveTo(int fsRef) {
        this.moveTo((FeatureStructure)this.ll_getIndex().getCasImpl().ll_getFSForRef(fsRef));
    }

    public int ll_indexSizeMaybeNotCurrent();

    public LowLevelIndex<T> ll_getIndex();

    public int ll_maxAnnotSpan();

    public boolean isIndexesHaveBeenUpdated();

    public boolean maybeReinitIterator();

    @Override
    default public void moveToFirst() {
        this.maybeReinitIterator();
        this.moveToFirstNoReinit();
    }

    @Override
    default public void moveToLast() {
        this.maybeReinitIterator();
        this.moveToLastNoReinit();
    }

    @Override
    default public void moveTo(FeatureStructure fs) {
        this.maybeReinitIterator();
        this.moveToNoReinit(fs);
    }

    public void moveToFirstNoReinit();

    public void moveToLastNoReinit();

    public void moveToNoReinit(FeatureStructure var1);

    public Comparator<TOP> getComparator();

    default public void ll_remove() {
        LowLevelIndex<T> idx = this.ll_getIndex();
        if (null == idx) {
            UIMAFramework.getLogger().warn("remove called on UIMA iterator but iterator not over any index");
        } else {
            idx.getCasImpl().removeFsFromIndexes((FeatureStructure)this.get());
        }
    }

    default public boolean isMoveToSupported() {
        return false;
    }
}

