/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.property;

import com.github.mangstadt.vinnie.SyntaxStyle;
import com.github.mangstadt.vinnie.validate.AllowedCharacters;
import com.github.mangstadt.vinnie.validate.VObjectValidator;
import ezvcard.VCard;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.ValidationWarning;
import ezvcard.property.TextProperty;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawProperty
extends TextProperty {
    private String propertyName;
    private VCardDataType dataType;

    public RawProperty(String propertyName, String value) {
        this(propertyName, value, null);
    }

    public RawProperty(String propertyName, String value, VCardDataType dataType) {
        super(value);
        this.propertyName = propertyName;
        this.dataType = dataType;
    }

    public RawProperty(RawProperty original) {
        super(original);
        this.propertyName = original.propertyName;
        this.dataType = original.dataType;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public VCardDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(VCardDataType dataType) {
        this.dataType = dataType;
    }

    @Override
    protected void _validate(List<ValidationWarning> warnings, VCardVersion version, VCard vcard) {
        SyntaxStyle syntax = version.getSyntaxStyle();
        AllowedCharacters allowed = VObjectValidator.allowedCharactersParameterName((SyntaxStyle)syntax, (boolean)true);
        if (!allowed.check(this.propertyName)) {
            if (syntax == SyntaxStyle.OLD) {
                AllowedCharacters notAllowed = allowed.flip();
                warnings.add(new ValidationWarning(33, this.propertyName, notAllowed.toString(true)));
            } else {
                warnings.add(new ValidationWarning(24, this.propertyName));
            }
        }
    }

    @Override
    protected Map<String, Object> toStringValues() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("propertyName", this.propertyName);
        values.put("dataType", this.dataType);
        values.put("value", this.value);
        return values;
    }

    @Override
    public RawProperty copy() {
        return new RawProperty(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dataType == null ? 0 : this.dataType.hashCode());
        result = 31 * result + (this.propertyName == null ? 0 : this.propertyName.toLowerCase().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        RawProperty other = (RawProperty)obj;
        if (this.dataType == null ? other.dataType != null : !this.dataType.equals(other.dataType)) {
            return false;
        }
        return !(this.propertyName == null ? other.propertyName != null : !this.propertyName.equalsIgnoreCase(other.propertyName));
    }
}

