/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.CannotParseException;
import ezvcard.io.ParseContext;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.text.WriteContext;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.ClientPidMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientPidMapScribe
extends VCardPropertyScribe<ClientPidMap> {
    public ClientPidMapScribe() {
        super(ClientPidMap.class, "CLIENTPIDMAP");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return VCardDataType.TEXT;
    }

    @Override
    protected String _writeText(ClientPidMap property, WriteContext context) {
        VObjectPropertyValues.SemiStructuredValueBuilder builder = new VObjectPropertyValues.SemiStructuredValueBuilder();
        builder.append((Object)property.getPid());
        builder.append((Object)property.getUri());
        return builder.build(true, context.isIncludeTrailingSemicolons());
    }

    @Override
    protected ClientPidMap _parseText(String value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        VObjectPropertyValues.SemiStructuredValueIterator it = new VObjectPropertyValues.SemiStructuredValueIterator(value, 2);
        String pid = it.next();
        String uri = it.next();
        if (pid == null || uri == null) {
            throw new CannotParseException(3, new Object[0]);
        }
        return this.parse(pid, uri);
    }

    @Override
    protected void _writeXml(ClientPidMap property, XCardElement parent) {
        Integer pid = property.getPid();
        parent.append("sourceid", pid == null ? "" : pid.toString());
        parent.append(VCardDataType.URI, property.getUri());
    }

    @Override
    protected ClientPidMap _parseXml(XCardElement element, VCardParameters parameters, ParseContext context) {
        String sourceid = element.first("sourceid");
        String uri = element.first(VCardDataType.URI);
        if (uri == null && sourceid == null) {
            throw ClientPidMapScribe.missingXmlElements(VCardDataType.URI.getName().toLowerCase(), "sourceid");
        }
        if (uri == null) {
            throw ClientPidMapScribe.missingXmlElements(VCardDataType.URI);
        }
        if (sourceid == null) {
            throw ClientPidMapScribe.missingXmlElements("sourceid");
        }
        return this.parse(sourceid, uri);
    }

    @Override
    protected JCardValue _writeJson(ClientPidMap property) {
        return JCardValue.structured(property.getPid(), property.getUri());
    }

    @Override
    protected ClientPidMap _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        VObjectPropertyValues.StructuredValueIterator it = new VObjectPropertyValues.StructuredValueIterator(value.asStructured());
        String pid = it.nextValue();
        String uri = it.nextValue();
        return this.parse(pid, uri);
    }

    private ClientPidMap parse(String pid, String uri) {
        try {
            return new ClientPidMap(Integer.parseInt(pid), uri);
        }
        catch (NumberFormatException e) {
            throw new CannotParseException(4, new Object[0]);
        }
    }
}

