/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.obs.api;

import com.openexchange.obs.api.BuildServiceException;
import com.openexchange.obs.api.DistroNaming;

public final class ProjectReference {
    public static final ProjectReference CENTOS_5 = new ProjectReference("CentOS:CentOS-5");
    public static final ProjectReference DEBIAN_LENNY = new ProjectReference("Debian:Lenny");
    public static final ProjectReference DEBIAN_SQUEEZE = new ProjectReference("Debian:Squeeze");
    public static final ProjectReference DEBIAN_WHEEZY = new ProjectReference("Debian:Wheezy");
    public static final ProjectReference DEBIAN_JESSIE = new ProjectReference("Debian:Jessie");
    public static final ProjectReference DEBIAN_STRETCH = new ProjectReference("Debian:Stretch");
    public static final ProjectReference DEBIAN_BUSTER = new ProjectReference("Debian:Buster");
    public static final ProjectReference RHEL_5 = new ProjectReference("RedHat:RHEL-5");
    public static final ProjectReference RHEL_6 = new ProjectReference("RedHat:RHEL-6");
    public static final ProjectReference RHEL_7 = new ProjectReference("RedHat:RHEL-7");
    public static final ProjectReference SLE_11 = new ProjectReference("SUSE:SLE-11");
    public static final ProjectReference SLE_12 = new ProjectReference("SUSE:SLE-12");
    private final String name;

    public ProjectReference(String name) {
        this.name = name;
    }

    public static final ProjectReference byName(DistroNaming distro) throws BuildServiceException {
        switch (distro) {
            case CentOS5: {
                return CENTOS_5;
            }
            case DebianLenny: {
                return DEBIAN_LENNY;
            }
            case DebianSqueeze: {
                return DEBIAN_SQUEEZE;
            }
            case DebianWheezy: {
                return DEBIAN_WHEEZY;
            }
            case DebianJessie: {
                return DEBIAN_JESSIE;
            }
            case DebianStretch: {
                return DEBIAN_STRETCH;
            }
            case DebianBuster: {
                return DEBIAN_BUSTER;
            }
            case RHEL5: {
                return RHEL_5;
            }
            case RHEL6: {
                return RHEL_6;
            }
            case RHEL7: {
                return RHEL_7;
            }
            case SLE_11: {
                return SLE_11;
            }
            case SLE_12: {
                return SLE_12;
            }
        }
        throw new BuildServiceException("Unknown repository: \"" + (Object)((Object)distro) + "\".");
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectReference)) {
            return false;
        }
        ProjectReference other = (ProjectReference)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

