/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.transport.http;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.opensaml.ws.transport.http.HTTPOutTransport;

public class HTTPTransportUtils {
    protected HTTPTransportUtils() {
    }

    public static void addNoCacheHeaders(HTTPOutTransport transport) {
        transport.setHeader("Cache-control", "no-cache, no-store");
        transport.setHeader("Pragma", "no-cache");
    }

    public static void setUTF8Encoding(HTTPOutTransport transport) {
        transport.setCharacterEncoding("UTF-8");
    }

    public static void setContentType(HTTPOutTransport transport, String contentType) {
        transport.setHeader("Content-Type", contentType);
    }

    public static String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String getRawQueryStringParameter(String queryString, String paramName) {
        if (queryString == null) {
            return null;
        }
        String paramPrefix = paramName + "=";
        int start = queryString.indexOf(paramPrefix);
        if (start == -1) {
            return null;
        }
        int end = queryString.indexOf(38, start);
        if (end == -1) {
            return queryString.substring(start);
        }
        return queryString.substring(start, end);
    }
}

