/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.http;

import com.google.common.base.Preconditions;
import io.opencensus.contrib.http.AbstractHttpHandler;
import io.opencensus.contrib.http.HttpExtractor;
import io.opencensus.contrib.http.HttpRequestContext;
import io.opencensus.contrib.http.util.HttpMeasureConstants;
import io.opencensus.stats.Stats;
import io.opencensus.stats.StatsRecorder;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagValue;
import io.opencensus.tags.Tagger;
import io.opencensus.tags.Tags;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanBuilder;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.propagation.TextFormat;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class HttpClientHandler<Q, P, C>
extends AbstractHttpHandler<Q, P> {
    private final TextFormat.Setter<C> setter;
    private final TextFormat textFormat;
    private final Tracer tracer;
    private final StatsRecorder statsRecorder;
    private final Tagger tagger;

    public HttpClientHandler(Tracer tracer, HttpExtractor<Q, P> extractor, TextFormat textFormat, TextFormat.Setter<C> setter) {
        super(extractor);
        Preconditions.checkNotNull(setter, (Object)"setter");
        Preconditions.checkNotNull((Object)textFormat, (Object)"textFormat");
        Preconditions.checkNotNull((Object)tracer, (Object)"tracer");
        this.setter = setter;
        this.textFormat = textFormat;
        this.tracer = tracer;
        this.statsRecorder = Stats.getStatsRecorder();
        this.tagger = Tags.getTagger();
    }

    public HttpRequestContext handleStart(@Nullable Span parent, C carrier, Q request) {
        SpanContext spanContext;
        String spanName;
        SpanBuilder builder;
        Span span;
        Preconditions.checkNotNull(carrier, (Object)"carrier");
        Preconditions.checkNotNull(request, (Object)"request");
        if (parent == null) {
            parent = this.tracer.getCurrentSpan();
        }
        if ((span = (builder = this.tracer.spanBuilderWithExplicitParent(spanName = this.getSpanName(request, this.extractor), parent)).setSpanKind(Span.Kind.CLIENT).startSpan()).getOptions().contains(Span.Options.RECORD_EVENTS)) {
            this.addSpanRequestAttributes(span, request, this.extractor);
        }
        if (!(spanContext = span.getContext()).equals((Object)SpanContext.INVALID)) {
            this.textFormat.inject(spanContext, carrier, this.setter);
        }
        return this.getNewContext(span, this.tagger.getCurrentTagContext());
    }

    public void handleEnd(HttpRequestContext context, @Nullable Q request, @Nullable P response, @Nullable Throwable error) {
        Preconditions.checkNotNull((Object)context, (Object)"context");
        int httpCode = this.extractor.getStatusCode(response);
        this.recordStats(context, request, httpCode);
        this.spanEnd(context.span, httpCode, error);
    }

    private void recordStats(HttpRequestContext context, @Nullable Q request, int httpCode) {
        double requestLatency = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - context.requestStartTime);
        String methodStr = request == null ? "" : this.extractor.getMethod(request);
        TagContext startCtx = this.tagger.toBuilder(context.tagContext).put(HttpMeasureConstants.HTTP_CLIENT_METHOD, TagValue.create((String)(methodStr == null ? "" : methodStr)), HttpRequestContext.METADATA_NO_PROPAGATION).put(HttpMeasureConstants.HTTP_CLIENT_STATUS, TagValue.create((String)(httpCode == 0 ? "error" : Integer.toString(httpCode))), HttpRequestContext.METADATA_NO_PROPAGATION).build();
        this.statsRecorder.newMeasureMap().put(HttpMeasureConstants.HTTP_CLIENT_ROUNDTRIP_LATENCY, requestLatency).put(HttpMeasureConstants.HTTP_CLIENT_SENT_BYTES, context.sentMessageSize.get()).put(HttpMeasureConstants.HTTP_CLIENT_RECEIVED_BYTES, context.receiveMessageSize.get()).record(startCtx);
    }
}

