/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.v2.sharing.FilePermission;
import com.dropbox.core.v2.sharing.FolderPolicy;
import com.dropbox.core.v2.sharing.SharedContentLinkMetadata;
import com.dropbox.core.v2.users.Team;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

public class SharedFileMetadata {
    protected final SharedContentLinkMetadata linkMetadata;
    protected final FolderPolicy policy;
    protected final List<FilePermission> permissions;
    protected final Team ownerTeam;
    protected final String parentSharedFolderId;
    protected final String previewUrl;
    protected final String pathLower;
    protected final String pathDisplay;
    protected final String name;
    protected final String id;
    protected final Date timeInvited;

    public SharedFileMetadata(FolderPolicy policy, String previewUrl, String name, String id, SharedContentLinkMetadata linkMetadata, List<FilePermission> permissions, Team ownerTeam, String parentSharedFolderId, String pathLower, String pathDisplay, Date timeInvited) {
        this.linkMetadata = linkMetadata;
        if (policy == null) {
            throw new IllegalArgumentException("Required value for 'policy' is null");
        }
        this.policy = policy;
        if (permissions != null) {
            for (FilePermission x : permissions) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'permissions' is null");
            }
        }
        this.permissions = permissions;
        this.ownerTeam = ownerTeam;
        if (parentSharedFolderId != null && !Pattern.matches("[-_0-9a-zA-Z:]+", parentSharedFolderId)) {
            throw new IllegalArgumentException("String 'parentSharedFolderId' does not match pattern");
        }
        this.parentSharedFolderId = parentSharedFolderId;
        if (previewUrl == null) {
            throw new IllegalArgumentException("Required value for 'previewUrl' is null");
        }
        this.previewUrl = previewUrl;
        this.pathLower = pathLower;
        this.pathDisplay = pathDisplay;
        if (name == null) {
            throw new IllegalArgumentException("Required value for 'name' is null");
        }
        this.name = name;
        if (id == null) {
            throw new IllegalArgumentException("Required value for 'id' is null");
        }
        if (id.length() < 1) {
            throw new IllegalArgumentException("String 'id' is shorter than 1");
        }
        if (!Pattern.matches("id:.*", id)) {
            throw new IllegalArgumentException("String 'id' does not match pattern");
        }
        this.id = id;
        this.timeInvited = LangUtil.truncateMillis(timeInvited);
    }

    public SharedFileMetadata(FolderPolicy policy, String previewUrl, String name, String id) {
        this(policy, previewUrl, name, id, null, null, null, null, null, null, null);
    }

    public FolderPolicy getPolicy() {
        return this.policy;
    }

    public String getPreviewUrl() {
        return this.previewUrl;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public SharedContentLinkMetadata getLinkMetadata() {
        return this.linkMetadata;
    }

    public List<FilePermission> getPermissions() {
        return this.permissions;
    }

    public Team getOwnerTeam() {
        return this.ownerTeam;
    }

    public String getParentSharedFolderId() {
        return this.parentSharedFolderId;
    }

    public String getPathLower() {
        return this.pathLower;
    }

    public String getPathDisplay() {
        return this.pathDisplay;
    }

    public Date getTimeInvited() {
        return this.timeInvited;
    }

    public static Builder newBuilder(FolderPolicy policy, String previewUrl, String name, String id) {
        return new Builder(policy, previewUrl, name, id);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.linkMetadata, this.policy, this.permissions, this.ownerTeam, this.parentSharedFolderId, this.previewUrl, this.pathLower, this.pathDisplay, this.name, this.id, this.timeInvited});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            SharedFileMetadata other = (SharedFileMetadata)obj;
            return !(this.policy != other.policy && !this.policy.equals(other.policy) || this.previewUrl != other.previewUrl && !this.previewUrl.equals(other.previewUrl) || this.name != other.name && !this.name.equals(other.name) || this.id != other.id && !this.id.equals(other.id) || this.linkMetadata != other.linkMetadata && (this.linkMetadata == null || !this.linkMetadata.equals(other.linkMetadata)) || this.permissions != other.permissions && (this.permissions == null || !this.permissions.equals(other.permissions)) || this.ownerTeam != other.ownerTeam && (this.ownerTeam == null || !this.ownerTeam.equals(other.ownerTeam)) || this.parentSharedFolderId != other.parentSharedFolderId && (this.parentSharedFolderId == null || !this.parentSharedFolderId.equals(other.parentSharedFolderId)) || this.pathLower != other.pathLower && (this.pathLower == null || !this.pathLower.equals(other.pathLower)) || this.pathDisplay != other.pathDisplay && (this.pathDisplay == null || !this.pathDisplay.equals(other.pathDisplay)) || this.timeInvited != other.timeInvited && (this.timeInvited == null || !this.timeInvited.equals(other.timeInvited)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<SharedFileMetadata> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SharedFileMetadata value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("policy");
            FolderPolicy.Serializer.INSTANCE.serialize(value.policy, g);
            g.writeFieldName("preview_url");
            StoneSerializers.string().serialize(value.previewUrl, g);
            g.writeFieldName("name");
            StoneSerializers.string().serialize(value.name, g);
            g.writeFieldName("id");
            StoneSerializers.string().serialize(value.id, g);
            if (value.linkMetadata != null) {
                g.writeFieldName("link_metadata");
                StoneSerializers.nullableStruct(SharedContentLinkMetadata.Serializer.INSTANCE).serialize(value.linkMetadata, g);
            }
            if (value.permissions != null) {
                g.writeFieldName("permissions");
                StoneSerializers.nullable(StoneSerializers.list(FilePermission.Serializer.INSTANCE)).serialize(value.permissions, g);
            }
            if (value.ownerTeam != null) {
                g.writeFieldName("owner_team");
                StoneSerializers.nullableStruct(Team.Serializer.INSTANCE).serialize(value.ownerTeam, g);
            }
            if (value.parentSharedFolderId != null) {
                g.writeFieldName("parent_shared_folder_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.parentSharedFolderId, g);
            }
            if (value.pathLower != null) {
                g.writeFieldName("path_lower");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.pathLower, g);
            }
            if (value.pathDisplay != null) {
                g.writeFieldName("path_display");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.pathDisplay, g);
            }
            if (value.timeInvited != null) {
                g.writeFieldName("time_invited");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.timeInvited, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public SharedFileMetadata deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Date f_timeInvited;
            String f_pathDisplay;
            String f_pathLower;
            String f_parentSharedFolderId;
            Team f_ownerTeam;
            List<FilePermission> f_permissions;
            SharedContentLinkMetadata f_linkMetadata;
            String f_id;
            String f_name;
            String f_previewUrl;
            FolderPolicy f_policy;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_policy = null;
                f_previewUrl = null;
                f_name = null;
                f_id = null;
                f_linkMetadata = null;
                f_permissions = null;
                f_ownerTeam = null;
                f_parentSharedFolderId = null;
                f_pathLower = null;
                f_pathDisplay = null;
                f_timeInvited = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("policy".equals(field)) {
                        f_policy = (FolderPolicy)FolderPolicy.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("preview_url".equals(field)) {
                        f_previewUrl = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("name".equals(field)) {
                        f_name = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("id".equals(field)) {
                        f_id = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("link_metadata".equals(field)) {
                        f_linkMetadata = StoneSerializers.nullableStruct(SharedContentLinkMetadata.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("permissions".equals(field)) {
                        f_permissions = StoneSerializers.nullable(StoneSerializers.list(FilePermission.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    if ("owner_team".equals(field)) {
                        f_ownerTeam = StoneSerializers.nullableStruct(Team.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("parent_shared_folder_id".equals(field)) {
                        f_parentSharedFolderId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("path_lower".equals(field)) {
                        f_pathLower = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("path_display".equals(field)) {
                        f_pathDisplay = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("time_invited".equals(field)) {
                        f_timeInvited = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_policy == null) {
                    throw new JsonParseException(p, "Required field \"policy\" missing.");
                }
                if (f_previewUrl == null) {
                    throw new JsonParseException(p, "Required field \"preview_url\" missing.");
                }
                if (f_name == null) {
                    throw new JsonParseException(p, "Required field \"name\" missing.");
                }
                if (f_id == null) {
                    throw new JsonParseException(p, "Required field \"id\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SharedFileMetadata value = new SharedFileMetadata(f_policy, f_previewUrl, f_name, f_id, f_linkMetadata, f_permissions, f_ownerTeam, f_parentSharedFolderId, f_pathLower, f_pathDisplay, f_timeInvited);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder {
        protected final FolderPolicy policy;
        protected final String previewUrl;
        protected final String name;
        protected final String id;
        protected SharedContentLinkMetadata linkMetadata;
        protected List<FilePermission> permissions;
        protected Team ownerTeam;
        protected String parentSharedFolderId;
        protected String pathLower;
        protected String pathDisplay;
        protected Date timeInvited;

        protected Builder(FolderPolicy policy, String previewUrl, String name, String id) {
            if (policy == null) {
                throw new IllegalArgumentException("Required value for 'policy' is null");
            }
            this.policy = policy;
            if (previewUrl == null) {
                throw new IllegalArgumentException("Required value for 'previewUrl' is null");
            }
            this.previewUrl = previewUrl;
            if (name == null) {
                throw new IllegalArgumentException("Required value for 'name' is null");
            }
            this.name = name;
            if (id == null) {
                throw new IllegalArgumentException("Required value for 'id' is null");
            }
            if (id.length() < 1) {
                throw new IllegalArgumentException("String 'id' is shorter than 1");
            }
            if (!Pattern.matches("id:.*", id)) {
                throw new IllegalArgumentException("String 'id' does not match pattern");
            }
            this.id = id;
            this.linkMetadata = null;
            this.permissions = null;
            this.ownerTeam = null;
            this.parentSharedFolderId = null;
            this.pathLower = null;
            this.pathDisplay = null;
            this.timeInvited = null;
        }

        public Builder withLinkMetadata(SharedContentLinkMetadata linkMetadata) {
            this.linkMetadata = linkMetadata;
            return this;
        }

        public Builder withPermissions(List<FilePermission> permissions) {
            if (permissions != null) {
                for (FilePermission x : permissions) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'permissions' is null");
                }
            }
            this.permissions = permissions;
            return this;
        }

        public Builder withOwnerTeam(Team ownerTeam) {
            this.ownerTeam = ownerTeam;
            return this;
        }

        public Builder withParentSharedFolderId(String parentSharedFolderId) {
            if (parentSharedFolderId != null && !Pattern.matches("[-_0-9a-zA-Z:]+", parentSharedFolderId)) {
                throw new IllegalArgumentException("String 'parentSharedFolderId' does not match pattern");
            }
            this.parentSharedFolderId = parentSharedFolderId;
            return this;
        }

        public Builder withPathLower(String pathLower) {
            this.pathLower = pathLower;
            return this;
        }

        public Builder withPathDisplay(String pathDisplay) {
            this.pathDisplay = pathDisplay;
            return this;
        }

        public Builder withTimeInvited(Date timeInvited) {
            this.timeInvited = LangUtil.truncateMillis(timeInvited);
            return this;
        }

        public SharedFileMetadata build() {
            return new SharedFileMetadata(this.policy, this.previewUrl, this.name, this.id, this.linkMetadata, this.permissions, this.ownerTeam, this.parentSharedFolderId, this.pathLower, this.pathDisplay, this.timeInvited);
        }
    }
}

