/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

class RemovePropertiesArg {
    protected final String path;
    protected final List<String> propertyTemplateIds;

    public RemovePropertiesArg(String path, List<String> propertyTemplateIds) {
        if (path == null) {
            throw new IllegalArgumentException("Required value for 'path' is null");
        }
        if (!Pattern.matches("/(.|[\\r\\n])*|id:.*|(ns:[0-9]+(/.*)?)", path)) {
            throw new IllegalArgumentException("String 'path' does not match pattern");
        }
        this.path = path;
        if (propertyTemplateIds == null) {
            throw new IllegalArgumentException("Required value for 'propertyTemplateIds' is null");
        }
        for (String x : propertyTemplateIds) {
            if (x == null) {
                throw new IllegalArgumentException("An item in list 'propertyTemplateIds' is null");
            }
            if (x.length() < 1) {
                throw new IllegalArgumentException("Stringan item in list 'propertyTemplateIds' is shorter than 1");
            }
            if (Pattern.matches("(/|ptid:).*", x)) continue;
            throw new IllegalArgumentException("Stringan item in list 'propertyTemplateIds' does not match pattern");
        }
        this.propertyTemplateIds = propertyTemplateIds;
    }

    public String getPath() {
        return this.path;
    }

    public List<String> getPropertyTemplateIds() {
        return this.propertyTemplateIds;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path, this.propertyTemplateIds});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            RemovePropertiesArg other = (RemovePropertiesArg)obj;
            return !(this.path != other.path && !this.path.equals(other.path) || this.propertyTemplateIds != other.propertyTemplateIds && !this.propertyTemplateIds.equals(other.propertyTemplateIds));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<RemovePropertiesArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(RemovePropertiesArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("path");
            StoneSerializers.string().serialize(value.path, g);
            g.writeFieldName("property_template_ids");
            StoneSerializers.list(StoneSerializers.string()).serialize(value.propertyTemplateIds, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public RemovePropertiesArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<String> f_propertyTemplateIds;
            String f_path;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_path = null;
                f_propertyTemplateIds = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("path".equals(field)) {
                        f_path = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("property_template_ids".equals(field)) {
                        f_propertyTemplateIds = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_path == null) {
                    throw new JsonParseException(p, "Required field \"path\" missing.");
                }
                if (f_propertyTemplateIds == null) {
                    throw new JsonParseException(p, "Required field \"property_template_ids\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            RemovePropertiesArg value = new RemovePropertiesArg(f_path, f_propertyTemplateIds);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

