/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gbase.client;

import com.google.api.gbase.client.AttributeHistogram;
import com.google.api.gbase.client.GmDisapproved;
import com.google.api.gbase.client.GmPublishingPriority;
import com.google.api.gbase.client.ItemTypeDescription;
import com.google.api.gbase.client.Stats;
import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Extension;
import com.google.gdata.data.PubControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataEntryExtension {
    private final BaseEntry<?> owner;
    private final ItemTypeDescription itemType;

    public MetadataEntryExtension(BaseEntry<?> owner) {
        this.owner = owner;
        this.itemType = new ItemTypeDescription(owner);
    }

    public AttributeHistogram getAttributeHistogram() {
        AttributeHistogram histogram = (AttributeHistogram)this.owner.getExtension(AttributeHistogram.class);
        if (histogram == null) {
            throw new IllegalStateException("Not a histogram feed entry.");
        }
        return histogram;
    }

    public Stats getStats() {
        return (Stats)this.owner.getExtension(Stats.class);
    }

    public boolean isEmpty() {
        return this.hasAttributeHistogram() || this.hasItemTypeDescription() || this.hasStats();
    }

    public boolean hasStats() {
        return this.owner.getExtension(Stats.class) != null;
    }

    public boolean hasAttributeHistogram() {
        return this.owner.getExtension(AttributeHistogram.class) != null;
    }

    public ItemTypeDescription getItemTypeDescription() {
        if (!this.hasItemTypeDescription()) {
            throw new IllegalStateException("Not an item-type entry.");
        }
        return this.itemType;
    }

    public boolean hasItemTypeDescription() {
        return this.itemType.getName() != null;
    }

    public boolean hasGmDisapproved() {
        return this.owner.getPubControl() != null && this.owner.getPubControl().getExtension(GmDisapproved.class) != null;
    }

    public GmPublishingPriority.Value getGmPublishingPriority() {
        PubControl pubControl = this.owner.getPubControl();
        if (pubControl == null) {
            return null;
        }
        GmPublishingPriority priority = (GmPublishingPriority)pubControl.getExtension(GmPublishingPriority.class);
        if (priority == null) {
            return null;
        }
        return priority.getValue();
    }

    public void setGmPublishingPriority(GmPublishingPriority.Value value) {
        GmPublishingPriority priority = new GmPublishingPriority();
        priority.setValue(value);
        PubControl pubControl = this.owner.getPubControl();
        if (pubControl == null) {
            pubControl = new PubControl();
            this.owner.setPubControl(pubControl);
        }
        pubControl.setExtension((Extension)priority);
    }
}

