/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.obs.api;

import com.openexchange.obs.api.Binary;
import com.openexchange.obs.api.BuildServiceException;
import com.openexchange.obs.api.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class BinaryParser {
    private static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

    private BinaryParser() {
    }

    public static Binary[] parse(InputStream is) throws BuildServiceException {
        Document document;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.parse(is);
            NodeList childs = document.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if ("binarylist".equals(node.getNodeName())) {
                    return BinaryParser.parseBinaryList(node);
                }
                if (3 == node.getNodeType()) continue;
                throw new BuildServiceException("Unknown node in binary list \"" + node.getNodeName() + "\".");
            }
        }
        catch (ParserConfigurationException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new BuildServiceException(e.getMessage(), e);
        }
        throw new BuildServiceException("Unable to parse project meta. " + Tools.transform(document));
    }

    private static Binary[] parseBinaryList(Node binaryList) throws DOMException, BuildServiceException {
        NodeList childs = binaryList.getChildNodes();
        ArrayList<Binary> binaries = new ArrayList<Binary>();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node node = childs.item(i);
            if ("binary".equals(node.getNodeName())) {
                binaries.add(BinaryParser.parseBinary(node));
                continue;
            }
            if (3 == node.getNodeType()) continue;
            throw new BuildServiceException("Unknown node in binary list \"" + node.getNodeName() + "\" \"" + node.getNodeValue() + "\".");
        }
        return binaries.toArray(new Binary[binaries.size()]);
    }

    private static Binary parseBinary(Node binaryNode) {
        NamedNodeMap attributes = binaryNode.getAttributes();
        String filename = attributes.getNamedItem("filename").getNodeValue();
        Binary binary = new Binary(filename);
        return binary;
    }
}

