/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.config.AliasedDiscoveryConfig;
import com.hazelcast.config.AliasedDiscoveryConfigUtils;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.InvalidConfigurationException;
import java.util.Arrays;
import java.util.List;

public final class ClientAliasedDiscoveryConfigUtils {
    private ClientAliasedDiscoveryConfigUtils() {
    }

    public static List<DiscoveryStrategyConfig> createDiscoveryStrategyConfigs(ClientConfig config) {
        return AliasedDiscoveryConfigUtils.map(ClientAliasedDiscoveryConfigUtils.aliasedDiscoveryConfigsFrom(config));
    }

    public static AliasedDiscoveryConfig getConfigByTag(ClientNetworkConfig config, String tag) {
        if ("aws".equals(tag)) {
            return config.getAwsConfig();
        }
        if ("gcp".equals(tag)) {
            return config.getGcpConfig();
        }
        if ("azure".equals(tag)) {
            return config.getAzureConfig();
        }
        if ("kubernetes".equals(tag)) {
            return config.getKubernetesConfig();
        }
        if ("eureka".equals(tag)) {
            return config.getEurekaConfig();
        }
        throw new InvalidConfigurationException(String.format("Invalid configuration tag: '%s'", tag));
    }

    public static List<AliasedDiscoveryConfig<?>> aliasedDiscoveryConfigsFrom(ClientConfig config) {
        ClientNetworkConfig networkConfig = config.getNetworkConfig();
        return Arrays.asList(networkConfig.getAwsConfig(), networkConfig.getGcpConfig(), networkConfig.getAzureConfig(), networkConfig.getKubernetesConfig(), networkConfig.getEurekaConfig());
    }

    public static AliasedDiscoveryConfig newAliasedDiscoveryConfig(String name) {
        if ("aws".equals(name)) {
            return new ClientAwsConfig();
        }
        return AliasedDiscoveryConfigUtils.newConfigFor(name);
    }
}

